#ifndef _IDMOPER_
#define _IDMOPER_
/*******************************************************************************
* FILE NAME: idmoper.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMOperation                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <irefcnt.hpp>
#include <ipoint.hpp>
#include <ihandle.hpp>
#include <idmitem.hpp>
#include <idmcomm.hpp>


class IDragInfo;
typedef IDragInfo _DRAGINFO;


class  IContainerObject;
class  IContainerControl;
class  IDMSourceBeginEvent;
class  IDMTargetEnterEvent;
class  IDMItemSeq;
class  IDMOperationData;
class  IDMSourceOperationData;

#pragma pack(4)


class IDMOperation : public IRefCounted {
typedef IRefCounted
  Inherited;
typedef IDM::Source
  Source;
public:

/*------------------------------- Drag Operations ----------------------------*/
virtual unsigned long
  operation        ( ) const;

virtual IDMOperation
  &setOperation    ( unsigned long op );

static const unsigned long
  IC_IMPORTU drag,
  IC_IMPORTU copy,
  IC_IMPORTU link,
  IC_IMPORTU move,
  IC_IMPORTU unknown;

/*-------------------------- Pointing Device Position ------------------------*/
virtual IPoint
  position              ( ) const;

virtual IDMOperation
 &setPosition           ( IPoint        position );

/*----------------------------- Drag Source Device ---------------------------*/
virtual Source
  source                ( ) const;

virtual IDMOperation
 &setSource             ( Source        source );

/*----------------------- Source and Target Window Support -------------------*/
virtual IWindowHandle
  sourceWindowHandle    ( ) const,
  targetWindowHandle    ( ) const;

virtual IWindow
 *sourceWindow          ( ) const,
 *targetWindow          ( ) const;

virtual IDMOperation
 &setSourceWindowHandle ( IWindowHandle window ),
 &setTargetWindowHandle ( IWindowHandle window );

/*-------------------------------- Drag Items --------------------------------*/
unsigned
  numberOfItems     ( );

IDMItem::Handle
  item              ( unsigned               position );

IDMOperation
 &replaceItem       ( unsigned               position,
                      const IDMItem::Handle& replacement ),
 &addItem           ( const IDMItem::Handle& newItem ),
 &removeItem        ( unsigned               position ),
 &removeItem        ( const IDMItem::Handle& itemToRemove );

/*------------------------------ Container Support ---------------------------*/
IContainerObject
 *containerObject        ( ) const;

IDMOperation
 &setContainerObject     ( IContainerObject*  object ),
 &setContainerRefreshOff ( IContainerControl* container ),
 &setContainerRefreshOn  ( );

/*------------------------------- Diagnostics --------------------------------*/
static Boolean
  debugSupport();

static void
  setDebugSupport(Boolean debugSupport = true);

protected:
/*------------------------------- Constructors -------------------------------*/
  IDMOperation     ( IDMSourceBeginEvent& event );

  IDMOperation     ( IDMTargetEnterEvent& event );

virtual
  ~IDMOperation    ( );

/*----------------------------- Operation Services ---------------------------*/
_DRAGINFO
 *dragInfo           ( ) const;

Boolean
  dragWasInterrupted ( ) const;

friend class IDMSourceOperationData;

IDMOperation
 &setDragInfo        ( _DRAGINFO* dragInfo ),
 &setDragResult      ( Boolean    result );

private:
/*--------------------------------- Private ----------------------------------*/
friend class IDragInfoWrapper;

unsigned long
  op;

IWindowHandle
  srcWindowHandle,
  tgtWindowHandle;

Source
  src;

IPoint
  pos;

IContainerObject
 *pCnrObj;

IContainerControl
 *pCnrRefresh;

_DRAGINFO
 *pPMDragInfo;

Boolean
  bDragResult;

IDMItemSeq
 *pDMItemSeqCl;

IDMItemSeq
 *itemCollection ();

IDMOperationData
 *fDMOperationData;

static Boolean
  fgDebugSupport;

}; // IDMOperation

#pragma pack()

  #include <idmoper.inl>

#endif //_IDMOPER_
