
/*******************************************************************************
* FILE NAME: idmprov.c                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the template functions                *
*   declared in idmprov.hpp.                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <idmprov.hpp>

template<class T>
IDMItemProviderFor<T>::IDMItemProviderFor()
{
} // IDMItemProviderFor

template<class T>
IDMItemProviderFor<T>::~IDMItemProviderFor()
{
} // ~IDMItemProviderFor

template<class T>
Boolean
IDMItemProviderFor<T>::provideSourceItems   ( const IDMSourceOperation::Handle& sourceOperation )
{
  return( T::generateSourceItems( sourceOperation ) );
} //provideSourceItems

template<class T>
IDMItem::Handle
IDMItemProviderFor<T>::provideTargetItemFor ( const IDMItem::Handle& dragItem )
{
  return( (IDMItem::Handle)new T( dragItem ) );
} // provideTargetItemFor
