#ifndef _IDMPROV_
#define _IDMPROV_
/*******************************************************************************
* FILE NAME: idmprov.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMItemProvider                                                          *
*       IDMItemProviderFor< >                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <idmsrcop.hpp>
#include <idmitem.hpp>

class IDMTargetEnterEvent;
class IDMTargetLeaveEvent;
class IDMTargetHelpEvent;
class IDMItemProviderData;

#pragma pack(4)

class IDMItemProvider : public IVBase {
typedef IVBase
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMItemProvider  ( );

virtual
  ~IDMItemProvider ( );

/*----------------------------- Drag Item Support ----------------------------*/
virtual Boolean
  provideSourceItems    ( const IDMSourceOperation::Handle& sourceOperation ),
  provideEnterSupport   ( IDMTargetEnterEvent&              event ),
  provideLeaveSupport   ( IDMTargetLeaveEvent&              event );
#ifndef IC_WIN_FLAGNOP
virtual Boolean
  provideHelpFor        ( IDMTargetHelpEvent&               event );
#endif

virtual IDMItem::Handle
  provideTargetItemFor  ( const IDMItem::Handle&            dragItem );

private:
/*--------------------------------- Private ----------------------------------*/

IDMItemProviderData
 *fDMItemProviderData;

}; // class IDMItemProvider


template < class T >
class IDMItemProviderFor : public IDMItemProvider {
typedef IDMItemProvider
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMItemProviderFor  ( ) ;
  virtual
    ~IDMItemProviderFor ( ) ;

/*----------------------------- Drag Item Support ----------------------------*/
virtual Boolean
  provideSourceItems   ( const IDMSourceOperation::Handle& sourceOperation ) ;

virtual IDMItem::Handle
  provideTargetItemFor ( const IDMItem::Handle& dragItem ) ;

}; // class IDMItemProviderFor


#ifndef __TEMPINC__
   #include <idmprov.c>
#endif

#pragma pack()

#endif //_IDMPROV_
