#ifndef _IDMRENDR_
#define _IDMRENDR_
/*******************************************************************************
* FILE NAME: idmrendr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMRenderer                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <istring.hpp>

class IDMSourceRenderer;
class IDMTargetRenderer;
class IDMRendererData;

#pragma pack(4)

class IDMRenderer : public IVBase {
typedef IVBase
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMRenderer  ( const char* rmfs, const char* types );

  IDMRenderer  ( );

virtual
  ~IDMRenderer ( );

/*------------------------- Supported Types and RMFs -------------------------*/
virtual IString
  supportedTypes    ( ) const,
  supportedRMFs     ( ) const;

virtual IDMRenderer
 &setSupportedTypes ( const char* types ),
 &setSupportedRMFs  ( const char* rmfs );

/*----------------------------- Default Renderers ----------------------------*/
static IDMSourceRenderer
 &defaultSourceRenderer    ( );

static IDMTargetRenderer
 &defaultTargetRenderer    ( );

static void
  setDefaultSourceRenderer ( IDMSourceRenderer& sourceRenderer ),
  setDefaultTargetRenderer ( IDMTargetRenderer& targetRenderer );

private:
/*--------------------------------- Private ----------------------------------*/

IString
  strTypes,
  strRMFs;

static IDMSourceRenderer
 *pSource;

static IDMTargetRenderer
 *pTarget;

IDMRendererData
 *fDMRendererData;

}; // class IDMRenderer

#pragma pack()

#endif // _IDMRENDR_
