#ifndef _IDMSRCH_
#define _IDMSRCH_
/*******************************************************************************
* FILE NAME: idmsrch.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMSourceHandler                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <idmcomm.hpp>
#include <idmhndlr.hpp>
#include <idmsrcop.hpp>
#include <idmsrcrn.hpp>
#include <idmitem.hpp>

class IWindow;
class IEntryField;
class IMultiLineEdit;
class IContainerControl;
class IDMSourceBeginEvent;
class IDMSourcePrepareEvent;
class IDMSourceRenderEvent;
class IDMSourceEndEvent;
class IDMSourceDiscardEvent;
class IDMSourcePrintEvent;
class IDMSourceHandlerData;

#pragma pack(4)


class IDMSourceHandler : public IDMHandler {
typedef IDMHandler
  Inherited;
typedef IDM::DragImageStyle
  DragImageStyle;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMSourceHandler  ( IWindow*           window );

  IDMSourceHandler  ( IEntryField*       entryField );

  IDMSourceHandler  ( IMultiLineEdit*    multiLineEdit );

  IDMSourceHandler  ( IContainerControl* containerControl );

  IDMSourceHandler  ( );

virtual
  ~IDMSourceHandler ( );

/*--------------------------- Renderer Processing ----------------------------*/
virtual unsigned
  numberOfRenderers ( );

virtual IDMSourceRenderer
 *renderer          ( unsigned                 position );

virtual IDMSourceHandler
 &replaceRenderer   ( unsigned                 position,
                      const IDMSourceRenderer& replacement ),
 &addRenderer       ( const IDMSourceRenderer& newRenderer ),
 &removeRenderer    ( const IDMSourceRenderer& rendererToRemove ),
 &setRenderer       ( const IDMSourceRenderer& newRenderer );

protected:
/*----------------------------- Event Dispatching ----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent&                event );

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  sourceBegin          ( IDMSourceBeginEvent&   event,
                         Boolean                container = true ),
  sourcePrepare        ( IDMSourcePrepareEvent& event ),
  sourceRender         ( IDMSourceRenderEvent&  event ),
  sourceEnd            ( IDMSourceEndEvent&     event );
virtual Boolean
  sourceDiscard        ( IDMSourceDiscardEvent& event ),
  sourcePrint          ( IDMSourcePrintEvent&   event );

/*------------------------------ Implementation ------------------------------*/
virtual IDMSourceOperation::Handle
  allocateOperation ( IDMSourceBeginEvent&              event,
                      DragImageStyle                    dragItemStyle ) const;

virtual Boolean
  findRenderersFor  ( const IDMSourceOperation::Handle& sourceOperation );

virtual unsigned
  findRendererFor   ( const IDMItem::Handle&            item );

private:
/*------------------------------ Hidden Members ------------------------------*/
virtual IDMHandler
 &replaceRenderer ( unsigned           position,
                    const IDMRenderer& replacement ),
 &addRenderer     ( const IDMRenderer& newRenderer ),
 &removeRenderer  ( unsigned           position ),
 &removeRenderer  ( const IDMRenderer& rendererToRemove ),
 &setRenderer     ( const IDMRenderer& newRenderer );

/*--------------------------------- Private ----------------------------------*/
void
  resolveRMFConflict (IDMItem::Handle&   item,
                      IDMSourceRenderer* pIDMSrcRenderer);

IDMSourceHandlerData
 *fDMSourceHandlerData;

}; // IDMSourceHandler

#pragma pack()

#endif //_IDMSRCH_
