#ifndef _IDMSRCRN_
#define _IDMSRCRN_
/*******************************************************************************
* FILE NAME: idmsrcrn.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMSourceRenderer                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <idmrendr.hpp>
#include <idmcomm.hpp>
#include <istring.hpp>

struct  _DRAGTRANSFER;

class   IDMSourceRenderEvent;
class   IDMSourcePrepareEvent;
class   IDMSourceEndEvent;
class   IDMSourceDiscardEvent;
class   IDMSourcePrintEvent;
class   IDMSourceRendererData;

#pragma pack(4)


class IDMSourceRenderer : public IDMRenderer {
typedef IDMRenderer
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDMSourceRenderer  ( const char* rmfs, const char* type = IDM::any );

  IDMSourceRenderer  ( );

virtual
  ~IDMSourceRenderer ( );

/*----------------------- Source and Target Rendering ------------------------*/
virtual IDMSourceRenderer
 &sourceRender             ( IDMSourceRenderEvent&  event ),
 &sourcePrepare            ( IDMSourcePrepareEvent& event ),
 &sourceEnd                ( IDMSourceEndEvent&     event );
#ifndef IC_WIN_FLAGNOP
virtual IDMSourceRenderer
 &sourceDiscard            ( IDMSourceDiscardEvent& event ),
 &sourcePrint              ( IDMSourcePrintEvent&   event ),
 &informTargetOfCompletion ( IDMSourceRenderEvent&  event );
#endif

virtual Boolean
  canRender     ( const IString&         types );

protected:
/*----------------------------- Renderer Specifics ---------------------------*/
virtual Boolean
  doRender        ( IDMSourceRenderEvent&  event ),
  doRenderPrepare ( IDMSourcePrepareEvent& event ),
  doRenderEnd     ( IDMSourceEndEvent&     event ),
#ifndef IC_WIN_FLAGNOP
  doDiscard       ( IDMSourceDiscardEvent& event ),
  doPrint         ( IDMSourcePrintEvent&   event );
#endif

private:
/*--------------------------------- Private ----------------------------------*/

_DRAGTRANSFER
 *pPMDragTransfer;

IDMSourceRendererData
 *fDMSourceRendererData;

}; // class IDMSourceRenderer

#pragma pack()

#endif // _IDMSRCRN_
