#ifndef _IDMTBBIT_
#define _IDMTBBIT_
/*******************************************************************************
* FILE NAME: idmtbbit.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMTBarButtonItem                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <idmitem.hpp>

class IDMSourceOperation;
class IToolBar;
class IToolBarButton;
class IDMTBarButtonItemData;

#pragma pack(4)

class IDMTBarButtonItem : public IDMItem {
typedef IDMItem
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMTBarButtonItem  ( IDMSourceOperation*    sourceOperation );

  IDMTBarButtonItem  ( const IDMItem::Handle& dragItem );

virtual
  ~IDMTBarButtonItem ( );


/*------------------------------ Source Items --------------------------------*/
static Boolean
  generateSourceItems ( IDMSourceOperation* sourceOperation );

/*----------------------- Tool Bar Button Operations -------------------------*/
virtual unsigned long
  supportedOperationsFor ( const IString& selectedRMFs ) const;

/*------------------------------ Drop Processing -----------------------------*/
virtual Boolean
  targetDrop ( IDMTargetDropEvent& event );

/*------------------------------ Shredder Support ----------------------------*/
#ifndef IC_WIN_FLAGNOP
virtual Boolean
  sourceDiscard ( IDMSourceDiscardEvent& event );
#endif

/*------------------------- Source and Target Tool Bar -----------------------*/
virtual IToolBar
 *sourceToolBar       ( ) const,
 *targetToolBar       ( ) const;

virtual IToolBarButton
 *sourceToolBarButton ( ) const,
 *targetToolBarButton ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
IToolBarButton
 *pSourceBtn,
 *pTargetBtn;

IDMTBarButtonItemData
 *fDMTBarButtonItemData;

}; // IDMTBarButtonItem

#pragma pack()

#endif // _IDMTBBIT_
