#ifndef _IDMTGTH_
#define _IDMTGTH_
/*******************************************************************************
* FILE NAME: idmtgth.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMTargetHandler                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <idmhndlr.hpp>
#include <idmtgtop.hpp>
#include <idmtgtrn.hpp>

class IDMTargetRenderer;
class IWindow;
class IEntryField;
class IMultiLineEdit;
class IContainerControl;
class IDMTargetEnterEvent;
class IDMTargetLeaveEvent;
class IDMTargetDropEvent;
class IDMTargetHelpEvent;
class IDMTargetEndEvent;
class IDMTargetHandlerData;

#pragma pack(4)

class IDMTargetHandler : public IDMHandler {
typedef IDMHandler
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMTargetHandler  ( IWindow*           window );

  IDMTargetHandler  ( IEntryField*       entryField );

  IDMTargetHandler  ( IMultiLineEdit*    multiLineEdit );

  IDMTargetHandler  ( IContainerControl* containerControl );

  IDMTargetHandler  ( );

virtual
  ~IDMTargetHandler ( );

/*-------------------------- Renderer Processing -----------------------------*/
virtual unsigned
  numberOfRenderers ( );

virtual IDMTargetRenderer
 *renderer          ( unsigned                 position );

virtual IDMTargetHandler
 &replaceRenderer   ( unsigned                 position,
                      const IDMTargetRenderer& replacement ),
 &addRenderer       ( const IDMTargetRenderer& newRenderer ),
 &removeRenderer    ( const IDMTargetRenderer& rendererToRemove ),
 &setRenderer       ( const IDMTargetRenderer& newRenderer );


protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent&              event );

/*---------------------------- Event Processing ------------------------------*/
virtual Boolean
  targetEnter          ( IDMTargetEnterEvent& event ),
  targetLeave          ( IDMTargetLeaveEvent& event ),
  targetDrop           ( IDMTargetDropEvent&  event,
                         Boolean              container = true ),
  targetHelp           ( IDMTargetHelpEvent&  event );
virtual Boolean
  targetEnd            ( IDMTargetEndEvent&   event );

/*------------------------------ Implementation ------------------------------*/
virtual IDMTargetOperation::Handle
  allocateOperation ( IDMTargetEnterEvent&              event ) const;

virtual Boolean
  findRenderersFor  ( const IDMTargetOperation::Handle& targetOperation );

virtual unsigned
  findRendererFor   ( const IDMItem::Handle&            item );

private:
/*------------------------------ Hidden Members ------------------------------*/
virtual IDMHandler
 &replaceRenderer ( unsigned           position,
                    const IDMRenderer& replacement ),
 &addRenderer     ( const IDMRenderer& newRenderer ),
 &removeRenderer  ( unsigned           position ),
 &removeRenderer  ( const IDMRenderer& rendererToRemove ),
 &setRenderer     ( const IDMRenderer& newRenderer );

IDMTargetHandlerData
 *fDMTargetHandlerData;

}; // IDMTargetHandler

#pragma pack()

#endif // _IDMTGTH_
