#ifndef _IDMTGTRN_
#define _IDMTGTRN_
/*******************************************************************************
* FILE NAME: idmtgtrn.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMTargetRenderer                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <idmcomm.hpp>
#include <idmrendr.hpp>
#include <idmitem.hpp>
#include <istring.hpp>

struct  _DRAGTRANSFER;

class   IDMTargetDropEvent;
class   IDMTargetEndEvent;
class   IDMTargetRendererData;

#pragma pack(4)

class IDMTargetRenderer : public IDMRenderer {
typedef IDMRenderer
  Inherited;
typedef IDM::DropIndicator
  DropIndicator;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMTargetRenderer  ( const char* rmfs, const char* type = IDM::any );

  IDMTargetRenderer  ( );

virtual
  ~IDMTargetRenderer ( );

/*-------------------------- Source and Target Rendering ---------------------*/
virtual IDMTargetRenderer
 &targetRender             ( IDMTargetDropEvent&    event,
                             const IDMItem::Handle& dragItem ),

#ifndef IC_WIN_FLAGNOP
 &targetRenderPrepare      ( IDMTargetDropEvent&    event,
                             const IDMItem::Handle& dragItem ),
 &targetRenderComplete     ( IDMTargetEndEvent&     event ),
#endif
 &informSourceOfCompletion ( const IDMItem::Handle& dragItem,
                             IDM::RenderCompletion  code =
                                           IDM::targetSuccessful );

virtual DropIndicator
  canRender                ( const IDMItem::Handle& dragItem );

virtual Boolean
  supportsOperation        ( const IDMItem::Handle& dragItem );

protected:
/*----------------------------- Renderer Specifics ---------------------------*/
virtual Boolean
  renderAtSource  ( IDMTargetDropEvent&    event,
                    const IDMItem::Handle& dragItem ),
  prepareAtSource ( IDMTargetDropEvent&    event,
                    const IDMItem::Handle& dragItem ),
  renderComplete  ( const IDMItem::Handle& dragItem,
                    void*                  pBuffer );

virtual IString
  renderToName    ( const IDMItem::Handle& dragItem );

private:
/*--------------------------------- Private ----------------------------------*/

_DRAGTRANSFER
 *pPMDragTransfer;

_DRAGTRANSFER
 *allocDragTransfer ( IDMTargetDropEvent&    dropEvent,
                      const IDMItem::Handle& pDI );

_DRAGTRANSFER
 *dragTransfer      ( ) const;

IDMTargetRendererData
 *fDMTargetRendererData;

}; // class IDMTargetRenderer

#pragma pack()

#endif // _IDMTGTRN_
