#ifndef _IDOCSTOR_INL_
#define _IDOCSTOR_INL_ 0
/*******************************************************************************
* FILE NAME: idocstor.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in idocstor.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IDOCSTOR_
  #undef  _IDOCSTOR_INL_
  #define _IDOCSTOR_INL_ 1
  #include <idocstor.hpp>
#endif

#if _IDOCSTOR_INL_
  #define inline
#endif


//===============================================================================
//
// inline members of class IDocumentStorage
//

inline
const IString&
IDocumentStorage::fileName() const
{
    return fFileName;
}

inline
IString
IDocumentStorage::fileToUse( const char* name ) const
{
    if (name)
        return name;
    else
        return fFileName;
}

inline
CAswStorage*
IDocumentStorage::storage() const
{
    return fpStorage;
}

inline
IComponent&
IDocumentStorage::component() const
{
    return *fpComponent;
}


#endif /* _IDOCSTOR_INL_ */

