/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IDQULST_H
#define _IDQULST_H

#include <iadqu.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqlst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGDequeAsList;

template <class Element, class ElementOps>
class IGDequeAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGDequeAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGDequeAsListCursor
                            (IGDequeAsList
                              <
                               Element, ElementOps> const&);

  IGDequeAsListCursor <Element, ElementOps>&
           operator=        (IGDequeAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGDequeAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGDequeAsList :
  public IADeque <Element> {
protected:

  typedef  IGDequeAsList <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGDequeAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGDequeAsListTypedef (Element, ElementOps);

public:

  typedef  IGDequeAsListCursor
            <Element, ElementOps> Cursor;


           IGDequeAsList
                            (INumber = 100);

           IGDequeAsList
                            (IGDequeAsList
                              <
                               Element, ElementOps> const&);

  IGDequeAsList <Element, ElementOps>&
           operator=        (IGDequeAsList
                              <
                               Element, ElementOps> const&);


protected:

           IGDequeAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGDequeAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGDequeAsListCursor
            <Element, ElementOps>;



};

template <class Element>
class IDequeAsList :
  public IGDequeAsList
          <Element, IStdOps <Element> > {

  typedef  IGDequeAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IDequeAsList <Element> Self;

#define IDequeAsListTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IDequeAsList
                            (INumber = 100);


protected:

           IDequeAsList
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGDequeAsList :
  public IGDequeAsList
          <Element, ElementOps > {

  typedef  IVGDequeAsList
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGDequeAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGDequeAsListTypedef (Element, ElementOps);

public:

           IVGDequeAsList
                            (INumber = 100);


protected:

           IVGDequeAsList
                              (PureImplementation&);

private:


};

template <class Element>
class IVDequeAsList :
  public IVGDequeAsList
          <Element, IStdOps <Element> > {

  typedef  IVGDequeAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVDequeAsList <Element> Self;

#define IVDequeAsListTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVDequeAsList
                            (INumber = 100);


protected:

           IVDequeAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <idqulst.inl>

#pragma info (restore)
#pragma pack ()

#endif
