/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGDequeAsListCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGDequeAsListCursor <Element, ElementOps>::
IGDequeAsListCursor
  (IGDequeAsList
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGDequeAsListCursor <Element, ElementOps>&
IGDequeAsListCursor <Element, ElementOps>::
operator=
  (IGDequeAsListCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGDequeAsListCursor <Element, ElementOps>::
IGDequeAsListCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGDequeAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IGDequeAsList <Element, ElementOps>::
IGDequeAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGDequeAsList <Element, ElementOps>::
IGDequeAsList
  (IGDequeAsList
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGDequeAsList <Element, ElementOps>&
IGDequeAsList <Element, ElementOps>::
operator= (IGDequeAsList
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGDequeAsList <Element, ElementOps>::
IGDequeAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGDequeAsList
 <Element, ElementOps>::Implementation&
IGDequeAsList <Element, ElementOps>::
ImplOf (IGDequeAsList
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IDequeAsList
// ---

// public members

template <class Element>
inline
IDequeAsList <Element>::
IDequeAsList (INumber numberOfElements)
: IGDequeAsList
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IDequeAsList <Element>::
IDequeAsList (PureImplementation& impl)
: IGDequeAsList
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGDequeAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IVGDequeAsList <Element, ElementOps>::
IVGDequeAsList (INumber numberOfElements)
: IGDequeAsList
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGDequeAsList <Element, ElementOps>::
IVGDequeAsList (PureImplementation& impl)
: IGDequeAsList
    <Element, ElementOps> (impl)
{
}

// ---
// IVDequeAsList
// ---

// public members

template <class Element>
inline
IVDequeAsList <Element>::
IVDequeAsList (INumber numberOfElements)
: IVGDequeAsList
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVDequeAsList <Element>::
IVDequeAsList (PureImplementation& impl)
: IVGDequeAsList
   <Element, IStdOps <Element> > (impl)
{
}
