#ifndef _IDRAWCV_
#define _IDRAWCV_
/*******************************************************************************
* FILE NAME: idrawcv.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDrawingCanvas                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icanvas.hpp>
#include <irect.hpp>


class IGList;
class IGraphicContext;
class IPoint;
class IDrawingCanvasData;

#pragma pack(4)

class IDrawingCanvas : public ICanvas {
typedef ICanvas
  Inherited;

public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  IDrawingCanvas( unsigned long      windowIdentifier,
                  IWindow*           parent,
                  IWindow*           owner,
                  const IRectangle&  initial = IRectangle(),
                  const Style&       style = defaultStyle() );

virtual
 ~IDrawingCanvas( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IDrawingCanvas, ICanvas, IWindow);
                                  // style class definition
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU useDefaultPaintHandler;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*------------------------------ Graphic List --------------------------------*/
virtual IDrawingCanvas
 &setGraphicList    ( IGList* list );

virtual IGList*
  graphicList       ( ) const;

/*----------------------------- Graphic Context ------------------------------*/
virtual IDrawingCanvas
 &setGraphicContext ( IGraphicContext* graphicContext );

virtual IGraphicContext
 *graphicContext    ( ) const;

protected:
/*----------------------------- Canvas Support -------------------------------*/
virtual ISize
  calcMinimumSize   ( ) const;

private:
/*------------------------------ Hidden Members ------------------------------*/
  IDrawingCanvas  ( const IDrawingCanvas& drawingCanvas );
IDrawingCanvas
 &operator=       ( const IDrawingCanvas& drawingCanvas );

/*--------------------------------- Private ----------------------------------*/
static Style
  fgCurrentDefaultStyle;

IGList
 *fList;
IGraphicContext
 *fGc;

IDrawingCanvasData
 *fDrawingCanvasData;
}; // IDrawingCanvas

INESTEDBITFLAGCLASSFUNCS(Style, IDrawingCanvas);

#pragma pack()

#endif // _IDRAWCV_
