/*******************************************************************************
* FILE NAME: iembmod.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IEmbedderModel                                                           *
*     IEmbeddedComponent                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   Portions or this component are based on work originating from Taligent.    *
*   (C) Copyright Taligent, Inc. 1996 - All rights reserved.                   *
*                                                                              *
*******************************************************************************/
#ifndef _IEMBMOD_
#define _IEMBMOD_

#include <imodel.hpp>
#include <icompnen.hpp>
#include <igrabhdl.hpp>
#include <irect.hpp>
#include <iptr.h>
#include <iseq.h>

// classes defined in this module
class IEmbeddedComponent;
class IEmbedderModel;

// forward references
class IEmbeddedComponentImp;
class CAswStorage;
class CAswContainer;
class CAswRootContainer;
class IUnknown; // SMY0221

#pragma pack(4)



/*******************************************************************************
*                                                                              *
*                           IEmbeddedComponent                                 *
*                                                                              *
*******************************************************************************/

class IEmbeddedComponent : public IVBase, public IMGrabbable
{
public:
    
/*----------------------- Construction/Destruction ---------------------------*/
    
                            IEmbeddedComponent();
                            IEmbeddedComponent( const IEmbeddedComponent& );
    virtual void            initialize( Boolean, Boolean );
    virtual                 ~IEmbeddedComponent();
        

/*------------------------------ Painting ------------------------------------*/

    virtual void            draw( IPresSpaceHandle&,
                                  const IRectangle&,
                                  Boolean metaFile = false );
    void                    showGrabHandles( Boolean bShow = true );
        
        
/*--------------------- Embedded Component Management ------------------------*/

    void                    goActive( long lVerb = 0 );
    void                    goInactive();
    IComponent::EAspect     aspect() const;
    void                    setAspect( const IComponent::EAspect );


/*----------------------------- Informational --------------------------------*/
    
    Boolean                 isInitialized() const;
    Boolean                 isInPlaceActive() const;
    const IRectangle&       area() const;
    virtual IRectangle      objectArea() const;
    virtual IString         name() const;
    IGUIBundle&             bundle() const;
    unsigned                number() const;
    IGrabHandles*           grabHandles() const;


/*---------------------- Sizing Notification Handlers ------------------------*/

    void                    resize( const IRectangle& );
    void                    setArea( const IRectangle& );
    virtual void            setObjectArea( const IRectangle& );

    
/*------------------------- Streaming Operators ------------------------------*/

    IBaseStream&            operator>>= ( IBaseStream& towhere ) const;
    IBaseStream&            operator<<= ( IBaseStream& fromwhere );

#ifdef IC_LIBRARYUSEONLY
    IEmbeddedComponentImp*  containedObject() const;
    IUnknown*               objectInterface() const; // SMY0221
    IPoint                  dragMouseOffset() const;
    TypeExtensionDeclarationsMacro(IEmbeddedComponent)
    virtual void            preinitialize( IGUIBundle& inBundle,
                                           CAswStorage* fromStorage = NULL );
#endif

protected:

/*-------------------------- IMGrabbable overrides ---------------------------*/

    virtual IRectangle      rect() const;
    virtual void            setRect( const IRectangle& );
    virtual IWindow&        inWindow() const;
    virtual Boolean         doDragDrop( const IPoint& );

private:
    IEmbeddedComponent&     operator=( const IEmbeddedComponent& );

    enum Version { kOriginalVersion };

    IRectangle              fArea;
    IComponent::EAspect     fAspect;
    unsigned short          fNumber; // A unique number for this component
    IGrabHandles*           fpGrabHandles;
    IGUIBundle*             fpBundle;
  
    IEmbeddedComponentImp*  fpImplementation;
    IPoint                  ftDragMouseOffset;
    
};


/*******************************************************************************
*                                                                              *
*                           IEmbedderModel                                     *
*                                                                              *
*******************************************************************************/

class IEmbedderModel : public IModel
{
public:
    
/*---------------------- Construction/Destruction ----------------------------*/

                            IEmbedderModel();
                            IEmbedderModel( const IEmbedderModel& );
    virtual                 ~IEmbedderModel();

    
/*------------------------- IModel Overrides ---------------------------------*/

    virtual void            attachTo( IComponent& );
    virtual Boolean         hasChanged() const;

    
/*-------------------- Embedded Component management -------------------------*/

    typedef ISequence< IElemPointer<IEmbeddedComponent> > ComponentList;

    const ComponentList&    componentList() const;
    IEmbeddedComponent*     selectedComponent() const;
    virtual void            selectComponent( IEmbeddedComponent* );
    virtual void            adopt( IEmbeddedComponent* );
    virtual IEmbeddedComponent* orphan( IEmbeddedComponent& );
    virtual void            deleteAll();

    // Subclasses can override this method to create custom EmbeddedComponents
    // this method creates an IEmbeddedComponent by default
    virtual IEmbeddedComponent* createEmbeddedComponent() const;

    
/*------------------------- Streaming Operators ------------------------------*/

    virtual IBaseStream&    operator>>= ( IBaseStream& ) const;
    virtual IBaseStream&    operator<<= ( IBaseStream& );


#ifdef IC_LIBRARYUSEONLY
    CAswContainer*          container() const;
    CAswRootContainer*      rootContainer() const;
    virtual void            fileRenamed( const IString& name );
    
    static INotificationId  AddedComponentId;
    static INotificationId  RemovedComponentId;
    static INotificationId  ComponentAreaChangedId;

    TypeExtensionDeclarationsMacro(IEmbedderModel)
#endif
    
private:
    IEmbedderModel&         operator=( const IEmbedderModel& );
    
    enum Version { kOriginalVersion };
    
    // List of all the embedded components in this model
    ComponentList           fComponentList;
    IEmbeddedComponent*     fpSelectedComponent;

    CAswContainer*          fpContainer;
    CAswRootContainer*      fpRootContainer; // either == fpContainer or NULL
    
    
}; // class IEmbedderModel


  #include <iembmod.inl>


#pragma pack()


#endif // _IEMBMOD_
