#ifndef _IENTRYFD_
  #define _IENTRYFD_
/*******************************************************************************
* FILE NAME: ientryfd.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IEntryField                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <itextctl.hpp>
#include <irect.hpp>

class IRange;
class ISize;
class IString;
class IResourceId;
class IColor;
class IEntryFieldData;

#pragma pack(4)

class IEntryField : public ITextControl {
typedef ITextControl
  Inherited;

public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  IEntryField  ( unsigned long        id,
                 IWindow*             parent,
                 IWindow*             owner,
                 const IRectangle&    initial = IRectangle(),
                 const Style&         style = defaultStyle() );

  IEntryField  ( unsigned long        id,
                 IWindow*             parent );

  IEntryField  ( const IWindowHandle& handle );

virtual
 ~IEntryField  ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IEntryField, IWindow, IControl);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU autoScroll,
  IC_IMPORTU margin,
  IC_IMPORTU readOnly,
  IC_IMPORTU unreadable,
  IC_IMPORTU leftAlign,
  IC_IMPORTU centerAlign,
  IC_IMPORTU rightAlign,
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU autoTab,
  IC_IMPORTU command,
  IC_IMPORTU sbcsData,
  IC_IMPORTU dbcsData,
  IC_IMPORTU mixedData,
#endif
#ifndef IC_MOTIFPM_FLAGNOP
  IC_IMPORTU border3D,
#endif
  IC_IMPORTU anyData;
static const Style
  IC_IMPORTU upperCase,
  IC_IMPORTU lowerCase;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*---------------------------- Enumerations ----------------------------------*/
enum Alignment {
  left,
  center,
  right
};

enum CharType {
  any,
  sbcs
#ifndef IC_WIN_FLAGNOP
  , dbcs,
  mixed
#endif
};

/*-------------------------------- Attributes --------------------------------*/
Alignment
  alignment          ( ) const;

CharType
  charType           ( ) const;

#ifndef IC_WIN_FLAGNOP
virtual IEntryField
 &enableCommand      ( Boolean   enable=true ),
 &disableCommand     ( );
#endif

// DEFECT 9744: Moving these 2 virtual functions to correct the VFT
#ifdef IC_PMWIN   // DEFECT 4624 : required for PM and WIN
virtual IEntryField
 &enableAutoTab      ( Boolean   enable=true ),
 &disableAutoTab     ( );
#endif

#ifndef IC_WIN_FLAGNOP
virtual IEntryField
 &enableMargin       ( Boolean   enable=true ),
 &disableMargin      ( ),
 &enableAutoScroll   ( Boolean   enable=true ),
 &disableAutoScroll  ( ),
 &setAlignment       ( Alignment alignment ),
 &setCharType        ( CharType  type );
#endif

Boolean
  isCommand          ( ) const,
  isAutoTab          ( ) const,
  isAutoScroll       ( ) const,
  isMargin           ( ) const;

/*-------------------------------- Clipboard Operations ----------------------*/
virtual IEntryField
 &cut        ( unsigned long timestamp=0 ),
 &copy       ( unsigned long timestamp=0 ),
 &paste      ( ),
 &clear      ( unsigned long timestamp=0 ),
 &discard    ( ),
 &removeAll  ( );

/*------------------------- Overloaded Disable/Enable Window -----------------*/
virtual IEntryField
 &disable  ( ),
 &enable   ( Boolean enable=true );

/*-------------------------------- Insert Mode -------------------------------*/
#ifndef IC_WIN_FLAGNOP
virtual IEntryField
 &enableInsertMode   ( Boolean insert=true ),
 &disableInsertMode  ( );
#endif

Boolean
  isInsertMode       ( ) const;

/*---------------------------- Read-Only Operations --------------------------*/
virtual IEntryField
 &enableDataUpdate   ( Boolean update=true ),
 &disableDataUpdate  ( );

Boolean
  isWriteable        ( ) const;

/*-------------------------------- Text Limit --------------------------------*/
virtual IEntryField
 &setLimit  ( unsigned long      textLimit ),
 &setLimit  ( const IResourceId& textLimit );

virtual unsigned long
  limit     ( ) const;

/*-------------------------------- Selected Text -----------------------------*/
static const long IC_IMPORTU end;

virtual IEntryField
 &selectRange    ( const IRange& range = IRange(0,end),
                   unsigned long timestamp = 0 );

IRange
  selectedRange ( ) const;

IString
  selectedText  ( ) const;

unsigned long
  selectedTextLength ( ) const;

virtual IEntryField
 &setCursorPosition( unsigned long newCursorPos );

unsigned long
  cursorPosition ( ) const;

/*-------------------------------- Left Index --------------------------------*/
virtual IEntryField
  &setLeftIndex ( unsigned long index );

#ifndef IC_WIN_FLAGNOP
unsigned long
  leftIndex    ( ) const;
#endif

/*-------------------------------- Test Operations ---------------------------*/
Boolean
  hasTextChanged  ( ) const,
  isEmpty         ( ) const,
  hasSelectedText ( ) const;

virtual IEntryField
 &setTextChangedFlag    ( Boolean changed=true ),
 &resetTextChangedFlag  ( );

/*---------------------------------- Colors ----------------------------------*/
virtual IColor
  foregroundColor ( ) const,
  backgroundColor ( ) const;


/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU insertModeId,
#endif
  IC_IMPORTU dataUpdateId,
  IC_IMPORTU limitId,
  IC_IMPORTU characterTypeId;

/*----------------------- Observer Notification ------------------------------*/
virtual IEntryField
 &enableNotification ( Boolean enable=true );

/*-------------------------------- Text Operations ---------------------------*/
virtual IEntryField
 &setText            ( const char* text ),
 &setText            ( const IResourceId& text );


protected:
/*------------------------------ Layout Support ------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;



/*---------------------------------- Styles ----------------------------------*/
virtual IEntryField
 &setStyle ( unsigned long style );

/*------------------------------- Constructors -------------------------------*/
  IEntryField ( );

/*-------------------------- Drag and Drop Support ---------------------------*/
virtual Boolean
  isDragStarting( IEvent &event );


private:
/*------------------------------ Hidden Members ------------------------------*/
  IEntryField  ( const IEntryField& entryField );
IEntryField
 &operator=    ( const IEntryField& entryField );

/*--------------------------------- Private ----------------------------------*/
friend class IEntryFieldNotifyHandler;
friend class IEntryHandler;

IRange
  getCursorInfo ( ) const;

void
  setCursorInfo ( const IRange &range );

static Style
  currentDefaultStyle;

enum ReadStatus {
  doesntMatter,
  wasInput,
  wasRead,
  wasInputButReset,
  wasReadButReset
};

ReadStatus
  eReadStatus;

Boolean
  queryInsMode;

IEntryFieldData
 *fEntryFieldData;

/*------------------------------ Obsolete Members ----------------------------*/
#if ( IC_OBSOLETE <= IC_OBSOLETE_2 )
public:
Boolean
  hasChanged      ( ) const;

virtual IEntryField
  &setChangedFlag ( Boolean changeFlag = true );
#endif

}; // IEntryField

INESTEDBITFLAGCLASSFUNCS(Style, IEntryField);

#pragma pack()

#endif  /* _IENTRYFD_ */
