/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IES_H
#define _IES_H

#include <iaes.h>
#include <iices.h>
#include <iives.h>
#include <iieslst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGEqualitySequence;

template <class Element, class ElementOps>
class IGEqualitySequenceCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGEqualitySequence
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGEqualitySequenceCursor
                            (IGEqualitySequence
                              <
                               Element, ElementOps> const&);

  IGEqualitySequenceCursor <Element, ElementOps>&
           operator=        (IGEqualitySequenceCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGEqualitySequenceCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGEqualitySequence :
  public IAEqualitySequence <Element> {
protected:

  typedef  IGEqualitySequence <Element, ElementOps> Self;

  typedef  IEqualitySequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICEqualitySequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGEqualitySequenceTypedef(Element, ElementOps)\
  typedef  IEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGEqualitySequenceTypedef (Element, ElementOps);

public:

  typedef  IGEqualitySequenceCursor
            <Element, ElementOps> Cursor;


           IGEqualitySequence
                            (INumber = 100);

           IGEqualitySequence
                            (IGEqualitySequence
                              <
                               Element, ElementOps> const&);

  IGEqualitySequence <Element, ElementOps>&
           operator=        (IGEqualitySequence
                              <
                               Element, ElementOps> const&);


protected:

           IGEqualitySequence
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGEqualitySequence
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGEqualitySequenceCursor
            <Element, ElementOps>;



};

template <class Element>
class IEqualitySequence :
  public IGEqualitySequence
          <Element, IEOps <Element> > {

  typedef  IGEqualitySequence
            <Element,
             IEOps <Element> > Inherited;

protected:

  typedef  IEqualitySequence <Element> Self;

#define IEqualitySequenceTypedef(Element)\
  typedef  IEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, IEOps <Element> >,\
             Implementation> Instantiation

public:

           IEqualitySequence
                            (INumber = 100);


protected:

           IEqualitySequence
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGEqualitySequence :
  public IGEqualitySequence
          <Element, ElementOps > {

  typedef  IVGEqualitySequence
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVEqualitySequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICEqualitySequenceImpl
            <IVEqualitySequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGEqualitySequenceTypedef(Element, ElementOps)\
  typedef  IEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGEqualitySequenceTypedef (Element, ElementOps);

public:

           IVGEqualitySequence
                            (INumber = 100);


protected:

           IVGEqualitySequence
                              (PureImplementation&);

private:


};

template <class Element>
class IVEqualitySequence :
  public IVGEqualitySequence
          <Element, IEOps <Element> > {

  typedef  IVGEqualitySequence
            <Element,
             IEOps <Element> > Inherited;

protected:

  typedef  IVEqualitySequence <Element> Self;

#define IVEqualitySequenceTypedef(Element)\
  typedef  IVEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, IEOps <Element> >,\
             Implementation> Instantiation

public:

           IVEqualitySequence
                            (INumber = 100);


protected:

           IVEqualitySequence
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ies.inl>

#pragma info (restore)
#pragma pack ()

#endif
