/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGEqualitySequenceCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGEqualitySequenceCursor <Element, ElementOps>::
IGEqualitySequenceCursor
  (IGEqualitySequence
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGEqualitySequenceCursor <Element, ElementOps>&
IGEqualitySequenceCursor <Element, ElementOps>::
operator=
  (IGEqualitySequenceCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGEqualitySequenceCursor <Element, ElementOps>::
IGEqualitySequenceCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGEqualitySequence
// ---

// public members

template <class Element, class ElementOps>
inline
IGEqualitySequence <Element, ElementOps>::
IGEqualitySequence (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGEqualitySequence <Element, ElementOps>::
IGEqualitySequence
  (IGEqualitySequence
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGEqualitySequence <Element, ElementOps>&
IGEqualitySequence <Element, ElementOps>::
operator= (IGEqualitySequence
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGEqualitySequence <Element, ElementOps>::
IGEqualitySequence (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGEqualitySequence
 <Element, ElementOps>::Implementation&
IGEqualitySequence <Element, ElementOps>::
ImplOf (IGEqualitySequence
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IEqualitySequence
// ---

// public members

template <class Element>
inline
IEqualitySequence <Element>::
IEqualitySequence (INumber numberOfElements)
: IGEqualitySequence
   <Element, IEOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IEqualitySequence <Element>::
IEqualitySequence (PureImplementation& impl)
: IGEqualitySequence
   <Element, IEOps <Element> > (impl)
{
}

// ---
// IVGEqualitySequence
// ---

// public members

template <class Element, class ElementOps>
inline
IVGEqualitySequence <Element, ElementOps>::
IVGEqualitySequence (INumber numberOfElements)
: IGEqualitySequence
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGEqualitySequence <Element, ElementOps>::
IVGEqualitySequence (PureImplementation& impl)
: IGEqualitySequence
    <Element, ElementOps> (impl)
{
}

// ---
// IVEqualitySequence
// ---

// public members

template <class Element>
inline
IVEqualitySequence <Element>::
IVEqualitySequence (INumber numberOfElements)
: IVGEqualitySequence
   <Element, IEOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVEqualitySequence <Element>::
IVEqualitySequence (PureImplementation& impl)
: IVGEqualitySequence
   <Element, IEOps <Element> > (impl)
{
}
