/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGEqualitySequenceAsListCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGEqualitySequenceAsListCursor <Element, ElementOps>::
IGEqualitySequenceAsListCursor
  (IGEqualitySequenceAsList
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGEqualitySequenceAsListCursor <Element, ElementOps>&
IGEqualitySequenceAsListCursor <Element, ElementOps>::
operator=
  (IGEqualitySequenceAsListCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGEqualitySequenceAsListCursor <Element, ElementOps>::
IGEqualitySequenceAsListCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGEqualitySequenceAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IGEqualitySequenceAsList <Element, ElementOps>::
IGEqualitySequenceAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGEqualitySequenceAsList <Element, ElementOps>::
IGEqualitySequenceAsList
  (IGEqualitySequenceAsList
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGEqualitySequenceAsList <Element, ElementOps>&
IGEqualitySequenceAsList <Element, ElementOps>::
operator= (IGEqualitySequenceAsList
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGEqualitySequenceAsList <Element, ElementOps>::
IGEqualitySequenceAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGEqualitySequenceAsList
 <Element, ElementOps>::Implementation&
IGEqualitySequenceAsList <Element, ElementOps>::
ImplOf (IGEqualitySequenceAsList
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IEqualitySequenceAsList
// ---

// public members

template <class Element>
inline
IEqualitySequenceAsList <Element>::
IEqualitySequenceAsList (INumber numberOfElements)
: IGEqualitySequenceAsList
   <Element, IEOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IEqualitySequenceAsList <Element>::
IEqualitySequenceAsList (PureImplementation& impl)
: IGEqualitySequenceAsList
   <Element, IEOps <Element> > (impl)
{
}

// ---
// IVGEqualitySequenceAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IVGEqualitySequenceAsList <Element, ElementOps>::
IVGEqualitySequenceAsList (INumber numberOfElements)
: IGEqualitySequenceAsList
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGEqualitySequenceAsList <Element, ElementOps>::
IVGEqualitySequenceAsList (PureImplementation& impl)
: IGEqualitySequenceAsList
    <Element, ElementOps> (impl)
{
}

// ---
// IVEqualitySequenceAsList
// ---

// public members

template <class Element>
inline
IVEqualitySequenceAsList <Element>::
IVEqualitySequenceAsList (INumber numberOfElements)
: IVGEqualitySequenceAsList
   <Element, IEOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVEqualitySequenceAsList <Element>::
IVEqualitySequenceAsList (PureImplementation& impl)
: IVGEqualitySequenceAsList
   <Element, IEOps <Element> > (impl)
{
}
