#ifndef _IEVENT_INL_
#define _IEVENT_INL_ 0
/*******************************************************************************
* FILE NAME: ievent.inl                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in ievent.hpp.                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IEVENT_
  #undef  _IEVENT_INL_
  #define _IEVENT_INL_ 1
  #include <ievent.hpp>
#endif

#if _IEVENT_INL_
  #define inline
#endif


inline  IWindowHandle IEvent::handle() const
{ return hCl; }

inline  IWindowHandle IEvent::controlHandle() const
{ return p_controlHandle; }

inline  IEvent& IEvent::setHandle  ( const IWindowHandle& handle )
{
  hCl = handle;
  return *this;
}

inline  IEvent& IEvent::setDispatchingHandle  ( const IWindowHandle& handle )
{
  p_dispatchingHandle = handle;
  return *this;
}

inline  IEvent& IEvent::setControlHandle  ( const IWindowHandle& handle )
{
  p_controlHandle = handle;
  return *this;
}

inline unsigned long IEvent::eventId() const
{ return ulClEvtId; }

inline  IEventParameter1 IEvent::parameter1() const
{ return epCl1; }

inline IEventParameter2 IEvent::parameter2() const
{ return epCl2; }

inline IEvent& IEvent::setResult(const IEventResult& er)
{
  erCl = er;
  return *this;
}

inline IEvent& IEvent::setResult(Boolean er)
{
  erCl = (IEventResult)er;
  return *this;
}

inline IEventResult IEvent::result() const
{ return erCl; }

#endif // _IEVENT_INL_
