#ifndef _IEVTDATA_
#define _IEVTDATA_
/*******************************************************************************
* FILE NAME: ievtdata.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IEventData                                                               *
*     IEventParameter1                                                         *
*     IEventParameter2                                                         *
*     ILowEventParameter                                                       *
*     IHighEventParameter                                                      *
*     IEventResult                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>

#pragma pack(4)

class IEventData : public IBase {
typedef IBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IEventData ( );
  IEventData ( void*            value );
  IEventData ( unsigned long    value );
  IEventData ( int              value );
  IEventData ( BooleanConstants value );

  IEventData ( unsigned short   lowValue,
               unsigned short   hiValue );

  IEventData ( unsigned short   lowValue,
               char             lowByte,
               char             hiByte );

/*--------------------------------- Contents ---------------------------------*/
unsigned short
  lowNumber    ( ) const,
  highNumber   ( ) const,
  number1      ( ) const,
  number2      ( ) const;

char
  lowLowByte   ( ) const,
  lowHighByte  ( ) const,
  highLowByte  ( ) const,
  highHighByte ( ) const,
  char1        ( ) const,
  char2        ( ) const,
  char3        ( ) const,
  char4        ( ) const;

/*-------------------------------- Conversion --------------------------------*/
unsigned long
  asUnsignedLong         ( ) const;
long
  asLong                 ( ) const;

  operator char*         ( ) const;
  operator unsigned long ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
void
 *pvClMsg;
}; // IEventData

typedef IEventData IEventParameter1;
typedef IEventData IEventParameter2;
typedef IEventData ILowEventParameter;
typedef IEventData IHighEventParameter;
typedef IEventData IEventResult;

#pragma pack()

  #include <ievtdata.inl>

#endif /* _IEVTDATA_ */
