#ifndef _IEVTDATA_INL_
#define _IEVTDATA_INL_ 0
/*******************************************************************************
* FILE NAME: ievtdata.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in ievtdata.hpp                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IEVTDATA_
  #undef  _IEVTDATA_INL_
  #define _IEVTDATA_INL_ 1
  #include <ievtdata.hpp>
#endif

#if _IEVTDATA_INL_
  #define inline
#endif

inline IEventData :: IEventData ( )
  : pvClMsg ( 0 )
  { }
inline IEventData :: IEventData ( void* value )
  {
  pvClMsg = value;
  }
inline IEventData :: IEventData ( unsigned long value )
  {
  pvClMsg = (void*)value;
  }
inline IEventData :: IEventData ( int value )
  {
  pvClMsg = (void*)((unsigned long)value);
  }
inline IEventData :: IEventData ( BooleanConstants value )
  {
  pvClMsg = (void*)((unsigned long)value);
  }
inline IEventData :: IEventData ( unsigned short lowValue,
                                  unsigned short hiValue )
  {
  pvClMsg = (void*)(lowValue | (unsigned long)hiValue << 16);
  }
inline IEventData :: IEventData ( unsigned short lowValue,
                                  char lowByte, char hiByte )
  {
  unsigned short hiValue = (unsigned short)(lowByte | (unsigned short)hiByte <<
  8); pvClMsg = (void*)(lowValue | (unsigned long)hiValue << 16);
  }
inline char  IEventData :: lowLowByte ( ) const
  {
  return (char)(unsigned long)pvClMsg;
  }
inline char  IEventData :: lowHighByte ( ) const
  {
  return (char)((unsigned long)pvClMsg >> 8);
  }
inline char  IEventData :: highLowByte ( ) const
  {
  return (char)((unsigned long)pvClMsg >> 16);
  }
inline char  IEventData :: highHighByte ( ) const
  {
  return (char)((unsigned long)pvClMsg >> 24);
  }
inline char  IEventData :: char1 ( ) const
  {
  return lowLowByte();
  }
inline char  IEventData :: char2 ( ) const
  {
  return lowHighByte();
  }
inline char  IEventData :: char3 ( ) const
  {
  return highLowByte();
  }
inline char  IEventData :: char4 ( ) const
  {
  return highHighByte();
  }
inline unsigned short  IEventData :: lowNumber ( ) const
  {
  return (unsigned short)(unsigned long)pvClMsg;
  }
inline unsigned short  IEventData :: highNumber ( ) const
  {
  return (unsigned short)((unsigned long)pvClMsg >> 16);
  }
inline unsigned short  IEventData :: number1 ( ) const
  {
  return lowNumber();
  }
inline unsigned short  IEventData :: number2 ( ) const
  {
  return highNumber();
  }
inline unsigned long  IEventData :: asUnsignedLong ( ) const
  {
  return (unsigned long)pvClMsg;
  }
inline long  IEventData :: asLong ( ) const
  {
  return (long)pvClMsg;
  }
inline IEventData :: operator char* ( ) const
  {
  return (char*)pvClMsg;
  }
inline IEventData :: operator unsigned long ( ) const
  {
  return (unsigned long)pvClMsg;
  }

#endif // _IEVTDATA_INL_
