#ifndef _IEVTPRIV_INL_
#define _IEVTPRIV_INL_ 0
/*******************************************************************************
* FILE NAME: ievtpriv.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in ievtpriv.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IEVTPRIV_
  #undef  _IEVTPRIV_INL_
  #define _IEVTPRIV_INL_ 1
  #include <ievtpriv.hpp>
#endif

#if _IEVTPRIV_INL_
  #define inline
#endif

inline IEventPrivateData::IEventPrivateData()
  : fCursor(0), fHandlerList(0)
{
}

inline IEventPrivateData::~IEventPrivateData()
{
}

inline IEventPrivateData& IEventPrivateData::setHandlerCursor(
                                             IHandlerList::Cursor* cursor)
{
  fCursor = cursor;
  return *this;
}

inline IEventPrivateData& IEventPrivateData::setHandlerList(
                                             IHandlerList* handlerList)
{
  fHandlerList = handlerList;
  return *this;
}

inline IHandlerList::Cursor* IEventPrivateData::handlerCursor() const
{
  return fCursor;
}

inline IHandlerList* IEventPrivateData::handlerList() const
{
  return fHandlerList;
}

#endif // _IEVTPRIV_INL_
