/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IEXC_H
#define _IEXC_H

#include <iiglobal.h>
#include <iexcbase.hpp>
#include <iexctxt.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)


#pragma SOMAsDefault (off)

class IPreconditionViolation : public IException {
public:

           IPreconditionViolation
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IPreconditionViolation
                            (IPreconditionViolation const&);

  virtual ~IPreconditionViolation
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IPreconditionViolation const&);


};

class IFullException : public IPreconditionViolation {
public:

           IFullException   (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IFullException   (IFullException const&);

  virtual ~IFullException   ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IFullException const&);


};

class IEmptyException : public IPreconditionViolation {
public:

           IEmptyException  (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IEmptyException  (IEmptyException const&);

  virtual ~IEmptyException  ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IEmptyException const&);


};

class INotEmptyException : public IPreconditionViolation {
public:

           INotEmptyException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           INotEmptyException
                            (INotEmptyException const&);

  virtual ~INotEmptyException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (INotEmptyException const&);


};

class INotBoundedException : public IPreconditionViolation {
public:

           INotBoundedException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           INotBoundedException
                            (INotBoundedException const&);

  virtual ~INotBoundedException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (INotBoundedException const&);


};

class ICursorInvalidException : public IPreconditionViolation {
public:

           ICursorInvalidException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           ICursorInvalidException
                            (ICursorInvalidException const&);

  virtual ~ICursorInvalidException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (ICursorInvalidException const&);


};

class IPositionInvalidException : public IPreconditionViolation {
public:

           IPositionInvalidException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IPositionInvalidException
                            (IPositionInvalidException const&);

  virtual ~IPositionInvalidException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IPositionInvalidException const&);


};

class INotContainsKeyException : public IPreconditionViolation {
public:

           INotContainsKeyException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           INotContainsKeyException
                            (INotContainsKeyException const&);

  virtual ~INotContainsKeyException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (INotContainsKeyException const&);


};

class IKeyAlreadyExistsException : public IPreconditionViolation {
public:

           IKeyAlreadyExistsException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IKeyAlreadyExistsException
                            (IKeyAlreadyExistsException const&);

  virtual ~IKeyAlreadyExistsException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IKeyAlreadyExistsException const&);


};

class IRootAlreadyExistsException : public IPreconditionViolation {
public:

           IRootAlreadyExistsException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IRootAlreadyExistsException
                            (IRootAlreadyExistsException const&);

  virtual ~IRootAlreadyExistsException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IRootAlreadyExistsException const&);


};

class IChildAlreadyExistsException : public IPreconditionViolation {
public:

           IChildAlreadyExistsException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IChildAlreadyExistsException
                            (IChildAlreadyExistsException const&);

  virtual ~IChildAlreadyExistsException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IChildAlreadyExistsException const&);


};

class IIdenticalCollectionException : public IPreconditionViolation {
public:

           IIdenticalCollectionException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IIdenticalCollectionException
                            (IIdenticalCollectionException const&);

  virtual ~IIdenticalCollectionException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IIdenticalCollectionException const&);


};

class IInvalidReplacementException : public IPreconditionViolation {
public:

           IInvalidReplacementException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IInvalidReplacementException
                            (IInvalidReplacementException const&);

  virtual ~IInvalidReplacementException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IInvalidReplacementException const&);


};

class ICyclicAttachException : public IPreconditionViolation {
public:

           ICyclicAttachException
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           ICyclicAttachException
                            (ICyclicAttachException const&);

  virtual ~ICyclicAttachException
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (ICyclicAttachException const&);


};

class IOutOfCollectionMemory : public IOutOfMemory {
public:

           IOutOfCollectionMemory
                            (char const*, unsigned long = 0,
                             Severity = IException::unrecoverable);

           IOutOfCollectionMemory
                            (IOutOfCollectionMemory const&);

  virtual ~IOutOfCollectionMemory
                            ();

  virtual
  char const*
           name             () const;

  static
  void     throwIt          (unsigned long,
                             char const*, unsigned long);

protected:

private:

  void     operator=        (IOutOfCollectionMemory const&);


};



#pragma SOMAsDefault (pop)


#pragma info (restore)
#pragma pack ()

#endif
