

#ifndef _IEXCBASE_
#define _IEXCBASE_
/*******************************************************************************
* FILE NAME: iexcbase.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IExceptionLocation                                                       *
*     IException                                                               *
*     IAccessError                                                             *
*     IAssertionFailure                                                        *
*     IDeviceError                                                             *
*     IInvalidParameter                                                        *
*     IInvalidRequest                                                          *
*     IResourceExhausted                                                       *
*     IOutOfMemory                                                             *
*     IOutOfSystemResource                                                     *
*     IOutOfWindowResource                                                     *
*                                                                              *
*   This file also contains many of the macros used to implement the           *
*   library exception handling mechanism.  This includes the IASSERT, ITHROW,  *
*   IRETHROW, IEXCEPTION_LOCATION, IEXCLASSDECLARE, IEXCLASSIMPLEMENT, and     *
*   and INO_EXCEPTIONS_SUPPORT macros.                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef IC_IMPORTB
  #if defined(__WINDOWS__) && defined(__IMPORTLIB__)
    #define IC_IMPORTB  _Import
  #else
    #define IC_IMPORTB
  #endif
#endif
#ifndef IC_IMPORTU
  #if defined(__WINDOWS__) && defined(__IMPORTLIB__)
    #define IC_IMPORTU  _Import
  #else
    #define IC_IMPORTU
  #endif
#endif
#ifndef IC_IMPORTD
  #if defined(__WINDOWS__) && defined(__IMPORTLIB__)
    #define IC_IMPORTD  _Import
  #else
    #define IC_IMPORTD
  #endif
#endif
#ifndef IC_IMPORTM
  #if defined(__WINDOWS__) && defined(__IMPORTLIB__)
    #define IC_IMPORTM  _Import
  #else
    #define IC_IMPORTM
  #endif
#endif

#include <imsgtext.hpp>

#pragma pack(4)


class IExcText;

class IExceptionLocation {
public:

/*------------------------------- Constructors -------------------------------*/
  IExceptionLocation ( const char*   fileName = 0,
                       const char*   functionName = 0,
                       unsigned long lineNumber = 0 );

/*-------------------------------- Attributes --------------------------------*/
const char
 *fileName     ( ) const,
 *functionName ( ) const;

unsigned long
  lineNumber ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
const char
 *pClFile,
 *pClFunction;
unsigned long
  ulClLineNo;




}; // IExceptionLocation

class IException {
public:

enum Severity { unrecoverable, recoverable };

/*------------------------------- Constructors -------------------------------*/
  IException ( const char*       errorText,
               unsigned long     errorId = 0,
               Severity          severity = IException::unrecoverable );
  IException ( const IException& exception );

virtual
 ~IException ( );

class TraceFn {
public:
/*--------------------------------- Tracing ----------------------------------*/
virtual void
  write   ( const char* buffer ),
  logData ( IException& exception );

protected:
/*-------------------------- Protected Constructors --------------------------*/
  TraceFn ( );

/*--------------------------------- Tracing ----------------------------------*/
virtual void
  exceptionLogged ( );




}; // TraceFn

/*---------------------------- Error Code Groups -----------------------------*/
typedef const char* ErrorCodeGroup;

static ErrorCodeGroup const
  IC_IMPORTB baseLibrary,
  IC_IMPORTB CLibrary,
  IC_IMPORTB operatingSystem,
  IC_IMPORTB presentationSystem,
  IC_IMPORTB other;

IException&
  setErrorCodeGroup ( ErrorCodeGroup errorGroup );

ErrorCodeGroup
  errorCodeGroup ( ) const;

/*------------------------------ Exception Text ------------------------------*/
IException
 &appendText  ( const char*   errorText ),
 &setText     ( const char*   errorText );

const char
 *text ( unsigned long indexFromTop = 0 ) const;

unsigned long
  textCount     ( ) const;

/*---------------------------- Exception Severity ----------------------------*/
IException
 &setSeverity ( Severity      severity );

virtual int
 isRecoverable ( ) const;

/*----------------------------- Error Identifier -----------------------------*/
IException
 &setErrorId  ( unsigned long errorId );

unsigned long
  errorId       ( ) const;

/*---------------------------- Exception Location ----------------------------*/
virtual IException
 &addLocation      ( const IExceptionLocation& location );

unsigned long
  locationCount ( ) const;

const IExceptionLocation
 *locationAtIndex ( unsigned long locationIndex ) const;

/*------------------------------ Exception Type ------------------------------*/
virtual const char
 *name ( ) const;

/*---------------------------- Exception Logging -----------------------------*/
static IException::TraceFn
  *setTraceFunction ( IException::TraceFn& traceFunction );

virtual IException
 &logExceptionData ( );

/*------------------------- Application Termination --------------------------*/
virtual void
  terminate ( );

/*------------------------------ Throw Support -------------------------------*/
static void
  assertParameter ( const char*        exceptionText,
                    IExceptionLocation location );

private:
/*----------------------------- Hidden Functions -----------------------------*/
IException
 &operator= ( const IException& exc );

/*--------------------------------- Private ----------------------------------*/
friend class IException::TraceFn;

Severity
  exsevCl;
unsigned long
  ulClErrorId;
IExceptionLocation
  exlocClArray[5];
unsigned long
  ulexlocClCount,
  ulClTxtLvlCount;
IExcText
 *msgtxtClTop;
ErrorCodeGroup
  fErrorGroup;



}; // IException

#if !defined( INO_EXCEPTIONS_SUPPORT )
  #define INO_EXCEPTIONS_SUPPORT 0
#endif


#if defined ( INO_FUNCTION_NAMES )
  #define IEXCEPTION_LOCATION() \
                IExceptionLocation(__FILE__, 0, __LINE__)
#elif defined ( __FUNCTION__ )
  #define IEXCEPTION_LOCATION()  \
                IExceptionLocation(__FILE__, __FUNCTION__, __LINE__)
#else
  #define IEXCEPTION_LOCATION()   \
                IExceptionLocation(__FILE__, 0, __LINE__)
#endif

#if (INO_EXCEPTIONS_SUPPORT)
  #define ITHROW(exc)\
     exc.addLocation(IEXCEPTION_LOCATION()),\
     exc.logExceptionData(),\
     exc.terminate()
#else
  #define ITHROW(exc)\
     exc.addLocation(IEXCEPTION_LOCATION()),\
     exc.logExceptionData(),\
     throw(exc)
#endif

#define IRETHROW(exc)\
     exc.addLocation(IEXCEPTION_LOCATION()),\
     exc.logExceptionData(),\
     throw

#if defined(IC_DEVELOP)
  #define IASSERT(test)\
      if(!(test))\
      {\
         IException::assertParameter(   \
   "The following expression must be true, but evaluated to false: " #test,\
         IEXCEPTION_LOCATION());\
      }
#else
  #define IASSERT(test)
#endif

#define IEXCLASSDECLARE(child,parent) class child : public parent {\
public:\
  child(const char* a, unsigned long b = 0,\
        Severity c = IException::unrecoverable);\
  virtual const char* name() const;\
  virtual ~child();\
  child(const child &);\
private:\
  child &operator = ( const child & );\
}

#define IEXCLASSIMPLEMENT(child,parent)\
  child :: child(const char* a, unsigned long b,\
                 Severity c)\
    : parent(a, b, c)\
        { }\
  const char* child :: name() const\
    {\
     return ( # child);\
    }\
  child :: ~child() {;}\
  child :: child(const child & a) : parent(a) {;}

IEXCLASSDECLARE(IAccessError,IException);
IEXCLASSDECLARE(IAssertionFailure,IException);
IEXCLASSDECLARE(IDeviceError,IException);
IEXCLASSDECLARE(IInvalidParameter,IException);
IEXCLASSDECLARE(IInvalidRequest,IException);
IEXCLASSDECLARE(IResourceExhausted,IException);
  IEXCLASSDECLARE(IOutOfMemory,IResourceExhausted);
  IEXCLASSDECLARE(IOutOfSystemResource,IResourceExhausted);
  IEXCLASSDECLARE(IOutOfWindowResource,IResourceExhausted);



/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOOC3I.LIB")
    #else
       #pragma library("CPPOOC3.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWOB3I.LIB")
       #pragma library("CPPWOU3I.LIB")
       #pragma library("CPPWOD3I.LIB")
       #pragma library("CPPWOM3I.LIB")
       #pragma library("CPPWOF3I.LIB")
    #else
       #pragma library("CPPWOC3.LIB")
    #endif
  #endif
#endif

#pragma pack()

#endif /* _IEXCBASE_ */


