#ifndef _IFILEDLG_
#define _IFILEDLG_
/*******************************************************************************
* FILE NAME: ifiledlg.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IFileDialog                                                              *
*     IFileDialog::Settings                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <iframe.hpp>
#include <istring.hpp>
#include <ipoint.hpp>

extern "C" {
   void* __stdcall _IFileDlgProc( void*         hwnd,
                                  unsigned long ulMsg,
                                  void*         mp1,
                                  void*         mp2 );
}

class StringSeq;
class IResourceId;
class IFileDialogSettingsData;
class IFileDialogData;
class IFileDialogHandler;
struct _FILEDLG;
struct _WidgetRec;
struct tagOFNA;

#pragma pack(4)

class IFileDialog : public IFrameWindow {
typedef IFrameWindow
  Inherited;
public:

class Style;
class Settings;

/*----------------------------- Constructors ---------------------------------*/

  IFileDialog(IWindow*        parent,
              IWindow*        owner,
              const Style&    style = defaultStyle() );

  IFileDialog(IWindow*        parent,
              IWindow*        owner,
              const Settings& settings,
              const Style&    style = defaultStyle() );

  IFileDialog(IWindow*        parent,
              IWindow*        owner,
              const Style&    style,
              const Settings& settings );

  IFileDialog(IWindow*        parent,
              IWindow*        owner,
              IHandler*       handler,
              const Style&    style = defaultStyle(),
              const Settings& settings = Settings() );

virtual
 ~IFileDialog( );

/*-------------------------------- Styles ------------------------------------*/
  INESTEDBITFLAGCLASSDEF0(Style, IFileDialog);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU noStyle,
  IC_IMPORTU modeless,
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU applyButton,
  IC_IMPORTU includeEAS,
  IC_IMPORTU filter,
  IC_IMPORTU preload,

#endif
//---------------------------------------------------
// Defect 9792: Add the 'explorer' style for Windows
//---------------------------------------------------
#ifndef IC_MOTIFPM_FLAGNOP
  IC_IMPORTU explorer,          // use Windows explorer style
#endif
  IC_IMPORTU helpButton,
  IC_IMPORTU multiSelection,
  IC_IMPORTU selectableListbox;

static void
  setDefaultStyle   ( const Style&    style );
static Style
  defaultStyle      ( );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

class Settings : public IBase {
public:
/*------------------------------ Constructors --------------------------------*/
  Settings();
 ~Settings();

/*---------------------- Dialog Customization --------------------------------*/
Settings
 &setTitle                 (const char*        newTitle ),
 &setTitle                 (const IResourceId& resId    ),
 &setOKButtonText          (const char*        newText  ),
 &setOKButtonText          (const IResourceId& resId    ),
 &setDialogTemplate        (const IResourceId& resId    ),
 &setPosition              (const IPoint&     position  );

IPoint
  position                 ( ) const;

IString
  title                    ( ) const,
  okButtonText             ( ) const;

Boolean
  isPositionSet            ( ) const,
  isDialogTemplateSet      ( ) const;

/*---------------- Setting Information About the Dialog ----------------------*/
Settings
 &setOpenDialog            ( ),
 &setSaveAsDialog          ( ),
 &setInitialFileType       (const char* fileType    ),
 &setInitialDrive          (const char* drive       ),
 &addFileType              ( const char* fileType, const char* filter = 0 ),
 &setFileName              (const char* fileName    );

IString
  fileName                 ( ) const,
  initialDrive             ( ) const,
  initialFileType          ( ) const;

Boolean
  isOpenDialog             ( ) const;

private:
/*------------------------------ Hidden Members ------------------------------*/
Settings    ( const Settings& settings );
Settings
 &operator= ( const Settings& settings );

/*--------------------------------- Private ----------------------------------*/
friend class IFileDialog;

StringSeq
 *fileTypes                ( ) const;

IString
  titleStr,
  OKButtonStr,
  fileNameStr,
  initialDriveStr,
  initialFileTypeStr;

IPoint
  pos;

Boolean
  isOpenDlg,
  isPosSet;

IFileDialogSettingsData
 *fSettingsData;
};   /* Settings */

/*---------------- Setting Information About the Dialog ----------------------*/
virtual IFileDialog
 &setId                            ( unsigned long  newIdentifier );

/*---------------- Getting Information About the Dialog ----------------------*/
Boolean
  isModeless                       ( ) const,
  pressedOK                        ( ) const;

static const unsigned long
  IC_IMPORTU ok,
  IC_IMPORTU cancel;

unsigned long
  id                               ( ) const,
  buttonPressedId                  ( ) const;

long
  returnValue                      ( ) const;


/*----------- Getting Information About the Chosen File ----------------------*/
unsigned
  selectedFileCount                ( ) const;

IString
  fileName                         (unsigned fileNumber = 0) const;


/*----------------------------- Color Functions ------------------------------*/
virtual IColor
  backgroundColor              ( ) const;

virtual IFileDialog
 &setBackgroundColor           ( const IColor& color );

protected:
/*-------------------------------Overrides------------------------------------*/

private:
/*------------------------------ Hidden Members ------------------------------*/
  IFileDialog  (const IFileDialog& fileDialog );
IFileDialog
 &operator=    (const IFileDialog& fileDialog );

/*--------------------------------- Private ----------------------------------*/
friend IFileDialogHandler;
struct tagOFNA
 *pFileDlgData;

friend void* __stdcall
  _IFileDlgProc( void*         hwnd,
                 unsigned long ulMsg,
                 void*         mp1,
                 void*         mp2 );

void IFileDialog :: initialize (IWindow*        parent,
                                IWindow*        owner,
                                const Style&    style,
                                IHandler*       handler,
                                const Settings& settings);

static Style
  currentDefaultStyle;

IFileDialogData
 *fFileDialogData;
}; /* IFileDialog */

#pragma pack()

  #include <ifiledlg.inl>

#endif // _IFILEDLG_
