#ifndef _IFILEHDR_
  #define _IFILEHDR_
/*******************************************************************************
* FILE NAME: ifilehdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declaration of the classes:                         *
*     IFileDialogHandler                                                       *
*     IFileDialogEvent                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>
#include <ihandler.hpp>

class IFileDialog;
class IString;
class IFileDialogHandler;

#pragma pack(4)

class IFileDialogEvent : public IEvent {
typedef IEvent
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IFileDialogEvent ( IEvent& event );
virtual
  ~IFileDialogEvent ( );

/*--------------------------- File Name Accessors ----------------------------*/
IString
  fileName         ( ) const;
unsigned long
  fileLength       ( ) const;

private:
friend IFileDialogHandler;
IString
  fFileNameSelected;
};


class IFileDialogHandler : public IHandler {
typedef IHandler
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IFileDialogHandler( );
virtual
  ~IFileDialogHandler ( );

/*---------------------------- Window Attachment -----------------------------*/
virtual IFileDialogHandler
  &handleEventsFor       ( IFileDialog* fileDialog ),
  &stopHandlingEventsFor ( IFileDialog* fileDialog );

protected:
/*----------------------------- Dispatch Events ------------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*---------------------------- File Dialog Events ----------------------------*/
virtual Boolean
#ifndef IC_WIN_FLAGNOP
  filter          ( IFileDialogEvent& event   ),
  filterName      ( const IString&    fileName,
                    IFileDialog*      dialog       ),
#endif
  validate        ( IFileDialogEvent& event   ),
  validateName    ( const IString&    fileName,
                    IFileDialog*      dialog       ),
  modelessResults ( IFileDialog*      endingDialog );
virtual Boolean
  modelessApply   ( IFileDialog*      modelessDialog,
                    const IString&    appliedFileName );

private:

/*------------------------------ Hidden functions ---------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window  ),
 &stopHandlingEventsFor ( IWindow* window  );

unsigned int
  fRegisteredOkMsg;
};

#pragma pack()

#endif /* _IFILEHDR_ */
