#ifndef _IFILSTRM_
#define _IFILSTRM_
/*******************************************************************************
* FILE NAME: ifilstrm.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of class(es):                                                  *
*     IFileStream                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*                                                                              *
*******************************************************************************/
#include <ibasstrm.hpp>
#include <fstream.h>

#pragma pack(4)


class IFileStream : public IBaseStream {
typedef IBaseStream
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IFileStream   ( const char* fileName,
                  Boolean     writeable = true);
virtual
 ~IFileStream   ( );

/*------------------------ Stream  Flushing ----------------------------------*/
virtual IFileStream
 &flush        ( );

/*------------------------ Random Access -------------------------------------*/
virtual IBaseStream::Position
  position              ( ) const,
  logicalEndOfStream    ( ) const,
  physicalEndOfStream   ( ) const;
virtual IFileStream
 &seek                  ( IBaseStream::Position position ),
 &setLogicalEndOfStream ( IBaseStream::Position position );

/*------------------------Write Access ---------------------------------------*/
virtual Boolean
  isWriteable() const;


protected:
/*------------------------ Buffer Management Overrides -----------------------*/
virtual void
  handleWriteBufferFull ( const void*    source,
                          size_t         byteCount ),
  handleReadBufferEmpty ( void*          target,
                          size_t         byteCount );

/*------------------------ Random Access -------------------------------------*/
virtual IFileStream
 &setPhysicalEndOfStream ( IBaseStream::Position position );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IFileStream ( );
  IFileStream ( const IFileStream& copy);
IFileStream
 &operator=   ( const IFileStream& copy);

/*----------------------------- Private --------------------------------------*/
IString
  fName;
Boolean
  fWriteable;
filebuf
  fBuffer;

};  // IFileStream


#pragma pack()

#endif /* _IFILSTRM_ */
