#ifndef _IFONTDLG_
#define _IFONTDLG_
/*******************************************************************************
* FILE NAME: IFONTDLG.HPP                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IFontDialog                                                              *
*     IFontDialog::Settings                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <iframe.hpp>
#include <istring.hpp>

extern "C" {
   void* __stdcall _IFontDlgProc( void*         hwnd,
                                  unsigned long ulMsg,
                                  void*         mp1,
                                  void*         mp2 );
}

class IResourceId;
class IPoint;
class IFont;
class IFontHandler;
class IFontDialogData;
class IFontDialogSettingsData;
struct _FONTDLG;
struct tagCHOOSEFONTA;

#pragma pack(4)

class IFontDialog : public IFrameWindow {
typedef IFrameWindow
  Inherited;
public:
class Style;
class Settings;
/*------------------------------ Constructors --------------------------------*/
 IFontDialog(IWindow*        parent,
             IWindow*        owner,
             const Style&    style = defaultStyle() );

 IFontDialog(IWindow*        parent,
             IWindow*        owner,
             const Settings& settings,
             const Style&    style = defaultStyle() );

 IFontDialog(IWindow*        parent,
             IWindow*        owner,
             const Style&    style,
             const Settings& settings );

 IFontDialog(IWindow*        parent,
             IWindow*        owner,
             IHandler*       handler,
             const Style&    style = defaultStyle(),
             const Settings& settings = Settings(0) );

virtual
 ~IFontDialog( );

/*---------------------------------- Styles ----------------------------------*/
  INESTEDBITFLAGCLASSDEF0(Style, IFontDialog);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU noStyle,
  IC_IMPORTU applyButton,
  IC_IMPORTU bitmapOnly,
  IC_IMPORTU fixedWidthOnly,
  IC_IMPORTU helpButton,
  IC_IMPORTU modeless,
  IC_IMPORTU noSynthesize,
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU proportionalOnly,
#endif
  IC_IMPORTU resetButton,
  IC_IMPORTU vectorOnly;

static void
  setDefaultStyle        ( const Style& newDefault );
static Style
  defaultStyle           ( );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

class Settings : public IBase {
public:
/*------------------------------- Constructors -------------------------------*/
  Settings   ( IFont*         font = 0 );
 ~Settings   ( );

/*--------------------------- Dialog Customization ---------------------------*/
Settings
 &setTitle            ( const char*        title       ),
 &setTitle            ( const IResourceId& text        ),
 &setPreviewText      ( const char*        previewText ),
 &setPosition         ( const IPoint&      position    );

Settings
 &setDialogTemplate   ( const IResourceId& templateId  );

/*------------------- Setting the Presentation Space -------------------------*/
Settings
 &setDisplayPS        ( const IPresSpaceHandle& presSpaceHandle ),
 &setPrinterPS        ( const IPresSpaceHandle& presSpaceHandle );

/*----------- Setting Information About the Initial Font ---------------------*/
Settings
 &setFont             ( IFont*        font       );


private:
/*------------------------------ Hidden Members ------------------------------*/
Settings    ( const Settings& settings );
Settings
 &operator= ( const Settings& settings );

/*--------------------------------- Private ----------------------------------*/
friend IFontDialog;

IFont
 *fApplyFont;


struct tagCHOOSEFONTA
 *fData;

IString
  fTitle,
  fPreview;

IPoint
  fPosition;

unsigned long
  dlgId,
  fSettingsChanged;

IFontDialogSettingsData
 *fSettingsData;
}; // IFontDialog::Settings


/*---------------- Setting Information About the Dialog ----------------------*/
IFontDialog
 &setId                  ( unsigned long  newIdentifier );

/*---------------- Getting Information About the Dialog ----------------------*/

static const unsigned long
  IC_IMPORTU ok,
  IC_IMPORTU cancel;

unsigned long
  id                     ( ) const,
  buttonPressedId        ( ) const;

long
  returnValue            ( ) const;

Boolean
  isModeless             ( ) const,
  pressedOK              ( ) const;

/*---------------- Getting Information About the Chosen Font -----------------*/
unsigned long
  pointSize             ( ) const;


/*----------------------------- Color Functions ------------------------------*/
virtual IColor
  backgroundColor              ( ) const;

virtual IFontDialog
 &setBackgroundColor           ( const IColor& color );

private:
/*------------------------------ Hidden Members ------------------------------*/
IFontDialog   ( const IFontDialog& fontDialog );
IFontDialog
 &operator=   ( const IFontDialog& fontDialog );

/*--------------------------------- Private ----------------------------------*/
friend void* __stdcall
  _IFontDlgProc( void*         hwnd,
                 unsigned long ulMsg,
                 void*         mp1,
                 void*         mp2 );
friend IFont;
friend IFontHandler;

void IFontDialog  :: initialize (IWindow*        parent,
                                 IWindow*        owner,
                                 const Style&    style,
                                 IHandler*       handler,
                                 const Settings& settings);

static Style
  currentDefaultStyle;

IFont
 *fApplyFont;
IHandler*
  _handlerToAdd;


struct tagCHOOSEFONTA
 *fData;

long
  fSRC,
  fReturnVal;

IString
  fTitle,
  fPreview;

IPoint
  fPosition;

unsigned long
  fDialogId,
  fSettingsChanged;

IFontDialogData
 *fFontDialogData;

}; // IFontDialog

#pragma pack()

  #include <ifontdlg.inl>

#endif // _IFONTDLG_
