#ifndef _IFRAME_
#define _IFRAME_
/*******************************************************************************
* FILE NAME: iframe.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declarations of the classes:                        *
*     IFrameWindow                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <iwindow.hpp>
#include <icconst.h>
#include <icmdevt.hpp>
#include <ihandle.hpp>
#include <irect.hpp>
#include <ireslib.hpp>

class IColor;
class IFont;
class IFrameExtension;
class IFrameExtensions;
class IFrameHandler;
class IFrameWindowData;
class IFrameWindowNotifyHandler;
class IToolBarList;

#pragma pack(4)

class IFrameWindow : public IWindow {
typedef IWindow
  Inherited;
public:
class Style;
enum FrameSource {
  dialogResource,
  noDialogResource,
  tryDialogResource
  };
/*------------------------------- Constructors -------------------------------*/
  IFrameWindow ( unsigned long id = IC_DEFAULT_FRAME_ID,
                 FrameSource   source = tryDialogResource );

  IFrameWindow ( const IResourceId& resId,
                 IWindow*           owner = 0,
                 FrameSource        source = tryDialogResource );

  IFrameWindow ( const IResourceId& resId,
                 IWindow*           parent,
                 IWindow*           owner,
                 FrameSource        source = tryDialogResource );

  IFrameWindow ( const IWindowHandle& hwnd );

  IFrameWindow ( const IResourceId&         resId,
                 const IFrameWindow::Style& style );

  IFrameWindow ( const IFrameWindow::Style& style,
                 const IResourceId&         resId = IC_DEFAULT_FRAME_ID );

  IFrameWindow ( const char*                title,
                 const IResourceId&         resId = IC_DEFAULT_FRAME_ID,
                 const IFrameWindow::Style& style = defaultStyle() );

  IFrameWindow ( const IResourceId&         resId,
                 IWindow*                   parent,
                 IWindow*                   owner ,
                 const IRectangle&          initRect,
                 const IFrameWindow::Style& style = defaultStyle(),
                 const char*                title = 0 );

virtual
 ~IFrameWindow ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF1( Style, IFrameWindow, IWindow );

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU accelerator,
  IC_IMPORTU alignNoAdjust,
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU animated,
  IC_IMPORTU appDBCSStatus,
#endif
  IC_IMPORTU border,
  IC_IMPORTU dialogBackground,
  IC_IMPORTU dialogBorder,
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU hideButton,
#endif
  IC_IMPORTU horizontalScroll,
  IC_IMPORTU maximizeButton,
  IC_IMPORTU maximized,
  IC_IMPORTU menuBar,
  IC_IMPORTU minimizeButton,
  IC_IMPORTU minimized,
  IC_IMPORTU minimizedIcon,
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU noMoveWithOwner,
#endif
  IC_IMPORTU shellPosition,
  IC_IMPORTU sizingBorder,
  IC_IMPORTU systemMenu,
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU systemModal,
#endif
  IC_IMPORTU titleBar,
  IC_IMPORTU verticalScroll,
  IC_IMPORTU windowList;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*----------------------- System-Menu-Related Actions ------------------------*/
virtual IFrameWindow
 &close          ( ),
 &maximize       ( ),
 &restore        ( ),
 &setRestoreRect ( const IRectangle& rect ),
 &minimize       ( );

virtual IRectangle
  maximizeRect  ( ) const,
  minimizeRect  ( ) const,
  restoreRect   ( ) const;

static IRectangle
  nextShellRect ( );

/*---------------------------- Moving and Sizing -----------------------------*/
virtual IFrameWindow
 &moveSizeToClient ( const IRectangle& clientRect );

virtual IRectangle
  clientRectFor    ( const IRectangle& frameRect ) const,
  frameRectFor     ( const IRectangle& clientRect ) const;

/*------------------------------- Border Size --------------------------------*/
unsigned long
  borderWidth     ( ) const,
  borderHeight    ( ) const;

ISize
  borderSize      ( ) const;

#ifndef IC_MOTIFWIN_FLAGNOP
IFrameWindow
 &setBorderWidth  ( unsigned long cx ),
 &setBorderHeight ( unsigned long cy ),
 &setBorderSize   ( const ISize&  size ),
 &setBorderSize   ( unsigned long cxcy ),
 &setBorderSize   ( unsigned long cx,
                    unsigned long cy );
#endif

/*------------------------------ Modal Display -------------------------------*/
virtual unsigned long
  showModally ( ),
  result      ( ) const;

virtual IFrameWindow
 &dismiss     ( unsigned long result = 0 ),
 &setResult   ( unsigned long result ),

 &notifyOwner ( unsigned long         id,
                ICommandEvent::Source source = ICommandEvent::unknown,
                Boolean               pointerDevice = false );

/*----------------------------- Application Icon -----------------------------*/
virtual IPointerHandle
  icon    ( ) const;

virtual IFrameWindow
 &setIcon ( const IPointerHandle& icon ),
 &setIcon ( const IResourceId&    iconResId ),
 &setIcon ( unsigned long         iconResId );

/*------------------------------ Mouse Pointer -------------------------------*/
virtual IPointerHandle
  mousePointer    ( ) const;

virtual IFrameWindow
 &setMousePointer ( const IPointerHandle& mousePointer );

/*--------------------------------- Colors -----------------------------------*/
#ifndef IC_WIN_FLAGNOP
virtual IColor
  backgroundColor              ( ) const;
#endif //!IC_WIN_FLAGNOP

#ifndef IC_MOTIFWIN_FLAGNOP
virtual IColor
  disabledBackgroundColor      ( ) const;
#endif //!IC_MOTIFWIN_FLAGNOP

#ifndef IC_WIN_FLAGNOP
virtual IFrameWindow
 &resetBackgroundColor         ( ),
 &resetDisabledBackgroundColor ( );
#endif //!IC_WIN_FLAGNOP

Boolean
  usesDialogBackground         ( ) const;

/*------------------------------ Font Functions ------------------------------*/
virtual IWindow
 &setFont       ( const IFont& font );

/*------------------------------ Client Window -------------------------------*/
virtual IWindowHandle
  clientHandle ( ) const;

virtual IWindow
 *client       ( ) const;

virtual IFrameWindow
 &setClient    ( IWindow* newClient );

/*----------------------------- Frame Extensions -----------------------------*/
enum Location {
#ifndef IC_MOTIFWIN_FLAGNOP
  leftOfTitleBar,
  rightOfTitleBar,
  leftOfMenuBar,
  rightOfMenuBar,
#endif
  leftOfClient,
  rightOfClient,
  aboveClient,
  belowClient
  };

enum SeparatorType {
  none,
  thinLine,
  thickLine
  };

virtual IFrameWindow
 &addExtension     ( IWindow*      newExtension,
                     Location      location,
                     unsigned long widthOrHeight,
                     SeparatorType separator = thinLine ),
 &addExtension     ( IWindow*      newExtension,
                     Location      location,
                     int           widthOrHeight,
                     SeparatorType separator = thinLine ),
 &addExtension     ( IWindow*      newExtension,
                     Location      location,
                     double        percentage,
                     SeparatorType separator = thinLine ),
 &addExtension     ( IWindow*      newExtension,
                     Location      location,
                     SeparatorType separator = thinLine ),

 &removeExtension  ( IWindow*      extension,
                     Boolean       updateDisplay = true ),

 &setExtensionSize ( IWindow*      extension,
                     unsigned long widthOrHeight ),
 &setExtensionSize ( IWindow*      extension,
                     int           widthOrHeight ),
 &setExtensionSize ( IWindow*      extension,
                     double        widthOrHeight ),
 &useExtensionMinimumSize ( IWindow* extension ),

 &update           ( );

virtual Boolean
  isAnExtension    ( const IWindow* window ) const;

/*------------------------------ Window Display ------------------------------*/
virtual IFrameWindow
 &show ( Boolean showWindow = true );

/*---------------------------- Window Destruction ----------------------------*/
virtual IFrameWindow
 &setDestroyOnClose  ( Boolean destroy = true );

Boolean
  willDestroyOnClose ( ) const;

/*--------------------------------- Testing ----------------------------------*/
Boolean
  isFlashing  ( ) const,
  isMaximized ( ) const,
  isMinimized ( ) const,
  isModal     ( ) const;

/*------------------------------- Window List --------------------------------*/
virtual IFrameWindow
 &addToWindowList      ( ),
 &removeFromWindowList ( );

/*------------------------- Standard Control Access --------------------------*/
virtual IWindowHandle
  handleFor ( const Style& standardControl ) const;

/*----------------------------- Window Flashing ------------------------------*/
virtual IFrameWindow
 &beginFlashing ( ),
 &endFlashing   ( );


/*------------------------------ Sibling Order -------------------------------*/
static void
  setDefaultOrdering ( IWindow::SiblingOrder ordering );
static IWindow::SiblingOrder
  defaultOrdering    ( );

/*------------------------------ Window Layout -------------------------------*/
IFrameWindow
 &setLayoutDistorted ( unsigned long layoutAttributesOn,
                       unsigned long layoutAttributesOff );

/*------------------------- Dialog Behavior Support --------------------------*/
virtual IWindowHandle
  defaultPushButton  ( ) const,
  matchForMnemonic   ( unsigned short character ) const;

/*--------------------- Notification Event Descriptions ----------------------*/
static INotificationId const
  IC_IMPORTU closeId,
  IC_IMPORTU activateId,
  IC_IMPORTU deactivateId;

/*-------------------------- Observer Notification ---------------------------*/
virtual IFrameWindow
 &enableNotification ( Boolean enable = true );


/*----------------------------- Tool Bar Support -----------------------------*/
IFrameWindow
 &setToolBarList ( IToolBarList* toolBarList );
IToolBarList
 *toolBarList    ( ) const;

protected:
/*----------------------- Frame Extensions Management ------------------------*/
IFrameExtensions
 *extensions    ( ) const;

unsigned
  findExtension ( IWindow* window );

IFrameWindow
 &setExtensions ( IFrameExtensions* extensions );

/*------------------------------ Implementation ------------------------------*/
static const Style
  IC_IMPORTU deferCreation;

IFrameWindow
 &tryToLoadDialog ( const IResourceId& resId,
                    IWindow*           parent = 0,
                    IWindow*           owner  = 0,
                    FrameSource        source = tryDialogResource );

IFrameWindow
 &initialize      ( const IResourceId& resId,
                    const Style&       style,
                    IWindow*           parent   = 0,
                    IWindow*           owner    = 0,
                    const IRectangle&  initRect = nextShellRect(),
                    const char*        title    = 0 );

unsigned long
  registerFrameClass ( const Style& style,
                       const IResourceId& resId );

IWindowHandle
  create ( unsigned long         id,
           const char*           title,
           unsigned long         style,
           const char*           windowClass,
           const IWindowHandle&  parent,
           const IWindowHandle&  owner,
           const IRectangle&     initRect,
           const void*           ctlData,
           const void*           presParams,
           IWindow::SiblingOrder ordering = defaultOrdering(),
           unsigned long         extendedStyle = 0 );

IFrameWindow
 &start  ( const IWindowHandle& hwnd );

IFrameWindow
 &addDefaultHandler    ( ),
 &removeDefaultHandler ( );


private:
/*------------------------------ Hidden Members ------------------------------*/
  IFrameWindow ( const IFrameWindow& frame );
IFrameWindow
 &operator=    ( const IFrameWindow& frame );

/*--------------------------------- Private ----------------------------------*/
friend class IFrameHandler;
friend class IFrameWindowNotifyHandler;
friend class IMenuBar;
friend class IMenuPrivate;

IFrameWindow
 &addExtension ( IFrameExtension* extension );

static const Style
  IC_IMPORTU styleBits;
static Style
  currentDefault;

static IWindow::SiblingOrder
  siblingCreateOrder;

IFrameWindowData
 *fFrameWindowData;

}; // class IFrame

INESTEDBITFLAGCLASSFUNCS(Style, IFrameWindow);

#pragma pack()

#endif // _IFRAME_
