#ifndef _IFRAMEVT_
#define _IFRAMEVT_
/*******************************************************************************
* FILE NAME: iframevt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declarations of the classes:                        *
*     IFrameEvent                                                              *
*     IFrameFormatEvent                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>

class IFrameWindow;
class IRectangle;
class ISWP;

#pragma pack(4)

class IFrameEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IFrameEvent ( const IEvent&      baseEvent );
  IFrameEvent ( const IFrameEvent& frameEvent );
IFrameEvent
 &operator=   ( const IFrameEvent& frameEvent );

 ~IFrameEvent ( );

/*------------------------------- Frame Window -------------------------------*/
IFrameWindow
 *frame ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
IFrameWindow
 *pFrame;
}; // IFrameEvent

class IFrameFormatEvent : public IFrameEvent {
typedef IFrameEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IFrameFormatEvent ( const IEvent&            baseEvent );
  IFrameFormatEvent ( const IFrameFormatEvent& fmtEvent );
 ~IFrameFormatEvent ( );

/*-------------------------- Formatting Information --------------------------*/
ISWP
 *swpArray      ( ) const;

IRectangle
  clientRect    ( ) const;

IFrameFormatEvent
 &setClientRect ( const IRectangle& rectangle );
}; // IFrameFormatEvent

#pragma pack()

  #include <iframevt.inl>

#endif /* _IFRAMEVT_ */
