#ifndef _IFRAMEXT_
#define _IFRAMEXT_
/*******************************************************************************
* FILE NAME: iframext.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IFrameExtension                                                          *
*     IFrameExtensions                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <iframe.hpp>
#include <ipoint.hpp>
#include <irect.hpp>
#include <iseq.h>

class IFrameExtensionData;
class IPresSpaceHandle;
class ISWP;

#pragma pack(4)

class IFrameExtension : public IBase {
typedef IBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IFrameExtension ( IWindow*                     window,
                    IFrameWindow::Location       location,
                    unsigned long                widthOrHeight,
                    IFrameWindow::SeparatorType  separator );
  IFrameExtension ( IWindow*                     window,
                    IFrameWindow::Location       location,
                    double                       percentage,
                    IFrameWindow::SeparatorType  separator );
  IFrameExtension ( IWindow*                     window,
                    IFrameWindow::Location       location,
                    IFrameWindow::SeparatorType  separator );

/*----------------------------- Extension Window -----------------------------*/
IWindow
 *control ( ) const;

/*------------------------------ Extension Type ------------------------------*/
enum Type {
  fixed,
  relative
  ,
  minimumSize
  };

Type
  type ( ) const;

/*----------------------------- Extension Sizing -----------------------------*/
virtual unsigned long
  fixedSize      ( ) const;

virtual double
  relativeSize   ( ) const;

virtual IFrameExtension
 &setSize        ( unsigned long     widthOrHeight ),
 &setSize        ( int               widthOrHeight ),
 &setSize        ( double            widthOrHeight );

virtual ISize
  sizeTo         ( const ISize&      baseSize ) const;

virtual IRectangle
  totalRectFor   ( const IRectangle& baseRect ) const,
  baseRectFor    ( const IRectangle& totalRect ) const;

virtual IFrameExtension
 &useMinimumSize ( );

/*---------------------------- Extension Location ----------------------------*/
IFrameWindow::Location
  location     ( ) const;

virtual ISWP
  attachTo     ( ISWP& baseSWP );

virtual unsigned long
  attachedToId ( ) const;

/*-------------------------------- Separator ---------------------------------*/

virtual unsigned long
  separatorWidth     ( ) const;

virtual void
  drawSeparator      ( const IPresSpaceHandle& psh );

private:
/*--------------------------------- Private ----------------------------------*/
IFrameExtensionData
 *pData;

IFrameWindow::Location
  mappedLocation ( ) const;

union {
  double
    extRelativeSize;
  unsigned long
    extFixedSize;
  };

Type
  extType;
IFrameWindow::Location
  extLocation;
IFrameWindow::SeparatorType
  extSeparator;
IPoint
  extPosition;
ISize
  extSize;
IWindow
 *extControl;

/*------------------------------ Hidden Members ------------------------------*/
IFrameExtension ( const IFrameExtension& frameExtension );
IFrameExtension
 &operator =    ( const IFrameExtension& frameExtension );
}; // IFrameExtension


class IFrameExtensions : public ISequence< IFrameExtension* > {
public:
/*------------------------------- Constructors -------------------------------*/
  IFrameExtensions ( );
 ~IFrameExtensions ( );
}; // IFrameExtensions

#pragma pack()

  #include <iframext.inl>

#endif /* _IFRAMEXT_ */
