#ifndef _IFRAMEXT_INL_
#define _IFRAMEXT_INL_ 0
/*******************************************************************************
* FILE NAME: iframext.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in iframext.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IFRAMEXT_
  #undef  _IFRAMEXT_INL_
  #define _IFRAMEXT_INL_ 1
  #include <iframext.hpp>
#endif

#if _IFRAMEXT_INL_
  #define inline
#endif

inline IFrameExtension :: IFrameExtension ( IWindow                     *window,
                                            IFrameWindow::Location       location,
                                            unsigned long                widthOrHeight,
                                            IFrameWindow::SeparatorType  separator )
  : pData( 0 ),
    extType( IFrameExtension::fixed ),
    extFixedSize( widthOrHeight ),
    extLocation( location ),
    extSeparator( separator ),
    extControl( window )
  {
  }

inline IFrameExtension :: IFrameExtension ( IWindow                     *window,
                                            IFrameWindow::Location       location,
                                            double                       percentage,
                                            IFrameWindow::SeparatorType  separator )
  : pData( 0 ),
    extType( IFrameExtension::relative ),
    extRelativeSize( percentage ),
    extLocation( location ),
    extSeparator( separator ),
    extControl( window )
  {
  }

inline IFrameExtension :: IFrameExtension ( IWindow                     *window,
                                            IFrameWindow::Location       location,
                                            IFrameWindow::SeparatorType  separator )
  : pData( 0 ),
    extType( IFrameExtension::minimumSize ),
    extFixedSize( 0 ),
    extLocation( location ),
    extSeparator( separator ),
    extControl( window )
  {
  }

inline IFrameExtension::Type IFrameExtension :: type ( ) const
  {
  return this->extType;
  }

inline IFrameWindow::Location IFrameExtension :: location ( ) const
  {
  return this->extLocation;
  }


inline IWindow *IFrameExtension :: control ( ) const
  {
  return this->extControl;
  }

#endif // _IFRAMEXT_INL_
