#ifndef _IFRAMHDR_
#define _IFRAMHDR_
/*******************************************************************************
* FILE NAME: iframhdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declarations of the classes:                        *
*     IFrameHandler                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <iframevt.hpp>
#include <icmdevt.hpp>

class IFrameWindow;

#pragma pack(4)

class IFrameHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IFrameHandler ( );

virtual
 ~IFrameHandler ( );

/*----------------------------- Frame Extensions -----------------------------*/
virtual unsigned long
  numberOfExtensions ( const IFrameWindow* frame ) const;

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  format      ( IFrameFormatEvent& formatEvent ),
  deactivated ( IFrameEvent&       frameEvent  ),
  draw        ( IFrameEvent&       frameEvent  ),
  closed      ( IFrameEvent&       frameEvent  ),
  activated   ( IFrameEvent&       frameEvent  ),
  saved       ( IFrameEvent&       frameEvent  ),
  command     ( ICommandEvent&     cmdEvent    ),
  calcRect    ( IFrameEvent&       frameEvent  );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Frame Extensions -----------------------------*/
virtual unsigned long
  positionExtensions ( IFrameFormatEvent& formatEvent,
                       unsigned long      numStdControls );
}; // IFrameHandler

#pragma pack()

#endif /* _IFRAMHDR_ */
