#ifndef _IGLIST_
#define _IGLIST_
/*******************************************************************************
* FILE NAME: iglist.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGList                                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <igraphic.hpp>


class IGraphicContext;
class ITransformMatrix;
class IGListSeq;

#pragma pack(4)

class IGList : public IGraphic {
typedef IGraphic
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IGList ( );

  IGList ( IGraphic&     graphic  );

  IGList ( const IGList& list     );

virtual
  ~IGList ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGList
  &drawOn      ( IGraphicContext& graphicContext );

/*------------------------------ Hit Testing ---------------------------------*/
virtual IGraphic
 *topGraphicUnderPoint    ( const IPoint&    point,
                            IGraphicContext& graphicContext ),

 *bottomGraphicUnderPoint ( const IPoint&    point,
                            IGraphicContext& graphicContext );


class Cursor : public IVBase {
typedef IVBase
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  Cursor ( const IGList&    list             );

  Cursor ( const IGList&    list,
           unsigned long    objectIdentifier );

  Cursor ( const IGList&    list,
           IGraphicContext& graphicContext,
           const IPoint&    hitPoint         );

virtual
 ~Cursor ( );

/*------------------------------ Cursor Positioning --------------------------*/
virtual IBase::Boolean
  setToFirst    ( ),

  setToNext     ( ),

  setToPrevious ( ),

  setToLast     ( ),

  isValid       ( ) const;

virtual void
  invalidate    ( );

private:
/*--------------------------------- Private ----------------------------------*/
const IGList
 *fCursorList;
void
 *fCursor;
enum CursorType {
  regular,
  id,
  hit
  };
CursorType
  fCursorType;
unsigned long
  fId;
IGraphicContext
 *fGc;
ITransformMatrix
 *fCtm,
 *fBtm;
friend class IGList;
Cursor::Cursor();
Cursor& operator=(Cursor&);
};


/*------------------------- Adding Graphics Objects --------------------------*/
virtual IGList
  &addAsFirst      ( IGraphic&     graphic ),

  &addAsLast       ( IGraphic&     graphic ),

  &addAsNext       ( const Cursor& cursor,
                     IGraphic&     graphic ),

  &addAsPrevious   ( const Cursor& cursor,
                     IGraphic&     graphic ),

  &addAtPosition   ( unsigned long position,
                     IGraphic&     graphic ),

  &replaceAt       ( const Cursor& cursor,
                     IGraphic&     graphic );


/*------------------------ Removing Graphic Objects --------------------------*/
virtual IGList
  &removeFirst     ( ),

  &removeLast      ( ),

  &removeAtPosition( unsigned long position   ),

  &removeAt        ( const Cursor& cursor     ),

  &removeAll       ( ),

  &removeAllWithId ( unsigned long identifier );


/*---------------------------- Querying the List -----------------------------*/
virtual unsigned long
  numberOfGraphics   ( ) const;

virtual IBase::Boolean
  isEmpty            ( ) const,
  isIGList           ( const Cursor& cursor   ) const;

virtual IGraphic
  *firstGraphic      ( ) const,

  *lastGraphic       ( ) const;

virtual IGraphic
  &graphicAt         ( const Cursor& cursor   ) const,

  &graphicAtPosition ( unsigned long position ) const;

virtual IRectangle
  boundingRectAt     ( const Cursor& cursor   ) const;

/*-------------------------- Reordering the List -----------------------------*/
virtual IGList&
  sort( long (*comparisonFunction)(IGraphic* const& graphic1,
                                   IGraphic* const& graphic2));


private:
/*--------------------------------- Private ----------------------------------*/
friend class IGList::Cursor;
IGList& operator= ( const IGList& );
IGListSeq
 *fList;
}; // IGList

#pragma pack()

#endif // _IGLIST_
