#ifndef _IGPIE_
#define _IGPIE_
/*******************************************************************************
* FILE NAME: igpie.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGPie                                                                    *
*     IGChord                                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <igraphic.hpp>
#include <ipoint.hpp>


class IGraphicContext;

#pragma pack(4)

class IGPie : public IGraphic {
typedef IGraphic
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGPie     ( const IRectangle& rectangle,
              double            startAngle,
              double            sweepAngle  );

  IGPie     ( const IGPie&      pie         );

IGPie&
  operator= ( const IGPie& pie              );

virtual
  ~IGPie    ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGPie
  &drawOn          ( IGraphicContext& graphicContext );

/*-------------------------- Enclosing Rectangle -----------------------------*/
virtual IGPie
  &setEnclosingRect   ( const IRectangle &rectangle );

virtual IRectangle
  enclosingRect       ( ) const;

/*------------------------- Start and Sweep Angles ---------------------------*/
virtual IGPie
  &setStartAngle   ( double startAngle ),
  &setSweepAngle   ( double sweepAngle );

virtual double
  startAngle       ( ) const,
  sweepAngle       ( ) const;

/*-------------------------------- Comparison --------------------------------*/
IBase::Boolean
  operator== ( const IGPie& pie ) const,
  operator!= ( const IGPie& pie ) const;

private:
/*-------------------------------- Private -----------------------------------*/
IRectangle
  fRect;
long
  fStart,
  fSweep;
}; // IGPie

class IGChord : public IGPie {
typedef IGPie
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGChord  ( const IRectangle& rectangle,
             double            startAngle,
             double            sweepAngle   );

  IGChord  ( const IGChord&    chord        );

virtual
  ~IGChord ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGChord
  &drawOn( IGraphicContext& graphicContext );

}; // IGChord

#pragma pack()

#endif // _IGPIE_
