/*******************************************************************************
* FILE NAME: igrabhdl.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMGrabbable                                                              *
*     IGrabHandler                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IGRABHDL_
#define _IGRABHDL_

#include <ivbase.hpp>
#include <irect.hpp>


// classes defined in this module
class IMGrabbable;
class IGrabHandles;


// forward references
class IWindow;
class IPresSpaceHandle;
class IGrabHandler;


#pragma pack(4)


/*******************************************************************************
*                                                                              *
*   Class IMGrabbable                                                          *
*                                                                              *
*   Mixin class for objects that wants to display grab handles.                *
*                                                                              *
*******************************************************************************/

class IMGrabbable 
{
public:
    
/*---------------------- Grabbable object protocol ---------------------------*/
  
    // return the grabbable objects area
    virtual IRectangle      rect() const = 0;

    // resize message to the grabbable object
    virtual void            setRect( const IRectangle& newRect ) = 0;

    // return the window in which the grab handles display
    virtual IWindow&        inWindow() const = 0;

    // initiate drag operation and take over handling of mouse events
    // (only called if grab handles are constructed with "dragMove" true)
    virtual Boolean         doDragDrop( const IPoint& startPoint );

};


/*******************************************************************************
*                                                                              *
*   Class IGrabHandles                                                         *
*                                                                              *
*   Handles used for moving and sizing an object in a window.                  *
*                                                                              *
*******************************************************************************/

class IGrabHandles : public IVBase
{
public:

/*---------------------- Construction/Destruction ----------------------------*/

                            IGrabHandles( IMGrabbable&,
                                          Boolean dragMove = false );
    virtual                 ~IGrabHandles();
    

/*------------------------ Location/Positioning ------------------------------*/

    enum ELocation          { kInside, kOutside,
                              kTopLeft, kTopMiddle, kTopRight,
                              kMiddleLeft, kMiddleRight,
                              kBottomLeft, kBottomMiddle, kBottomRight };
    
    virtual IRectangle&     getOutline() const;
    virtual ELocation       getLocation( const IPoint& position );

    virtual void            changeTo( const IRectangle& newRect );
    virtual void            moveTo( const IPoint& newPoint );

    
/*--------------------------- Rendering/Control ------------------------------*/
    
    virtual void            draw( IPresSpaceHandle& ps, 
                                  Boolean bWithHandles = true ) const;

    virtual void            mouseDown( const IPoint& position );

private:
    void                    moveHandles();

    IGrabHandler*           fpHandler;
    IRectangle              fOutline;
    IRectangle              fTL;
    IRectangle              fTM;
    IRectangle              fTR;
    IRectangle              fML;
    IRectangle              fMR;
    IRectangle              fBL;
    IRectangle              fBM;
    IRectangle              fBR;

friend class IGrabHandler;
};


#pragma pack()


#endif // _IGRABHDL_
