#ifndef _IGRAPHBT_
  #define _IGRAPHBT_
/*******************************************************************************
* FILE NAME: igraphbt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*    IGraphicPushButton                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ipushbut.hpp>
#include <irect.hpp>
#include <ipoint.hpp>
#include <ihandle.hpp>

class IIconControl;
class IGraphicPushButtonData;
class IResourceId;

#pragma pack(4)

class IGraphicPushButton : public IPushButton  {
typedef IPushButton
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  IGraphicPushButton( unsigned long         id,
                      IWindow*              parent,
                      IWindow*              owner,
                      const IResourceId&    bitmapOrIconId,
                      const IRectangle&     initial = IRectangle(),
                      const Style&          style = defaultStyle() );

  IGraphicPushButton( unsigned long         id,
                      IWindow*              parent,
                      IWindow*              owner,
                      unsigned long         bitmapOrIconId,
                      const IRectangle&     initial = IRectangle(),
                      const Style&          style = defaultStyle() );

  IGraphicPushButton( unsigned long         id,
                      IWindow*              parent,
                      IWindow*              owner,
                      const IBitmapHandle&  bitmap = IBitmapHandle(),
                      const IRectangle&     initial = IRectangle(),
                      const Style&          style = defaultStyle() );

  IGraphicPushButton( unsigned long         id,
                      IWindow*              parent,
                      IWindow*              owner,
                      const IPointerHandle& icon,
                      const IRectangle&     initial = IRectangle(),
                      const Style&          style = defaultStyle() );

  IGraphicPushButton( unsigned long         id,
                      IWindow*              parent );

  IGraphicPushButton( const IWindowHandle&  handle);

virtual
 ~IGraphicPushButton( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF4(Style, IGraphicPushButton, IWindow,
                        IControl, IButton, IPushButton);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU sizeToGraphic;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*--------------------------------- Graphic ----------------------------------*/
enum GraphicType {
  bitmapType,
  iconType
};

virtual IGraphicPushButton
 &setGraphic         ( unsigned long         bitmapOrIconId ),
 &setGraphic         ( const IResourceId&    bitmapOrIconId ),
 &setGraphic         ( const IBitmapHandle&  handle ),
 &setGraphic         ( const IPointerHandle& handle );
IPointerHandle
  icon               ( ) const;
IBitmapHandle
  bitmap             ( ) const;
GraphicType
  currentGraphicType ( ) const;
IIconControl&
  graphicWindow      ( ) const;

/*----------------------------- Graphic Size ---------------------------------*/
virtual IGraphicPushButton
 &enableSizeToGraphic   ( Boolean sizeToGraphic = true ),
 &disableSizeToGraphic  ( );
Boolean
  isSizeToGraphic       ( ) const;

/*---------------------------------- Margins ---------------------------------*/
IGraphicPushButton
 &setMarginSize   ( const ISize& size );
ISize
  marginSize      ( ) const;

/*---------------------------- Window Positioning ----------------------------*/

protected:
/*------------------------------ Layout Support ------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

private:
/*------------------------------ Hidden Members ------------------------------*/
  IGraphicPushButton  (const IGraphicPushButton& button );
IGraphicPushButton
 &operator=           (const IGraphicPushButton& button );

/*--------------------------------- Private ----------------------------------*/
friend class IGraphicPushButtonHandler;

IGraphicPushButton
 &initialize( const Style& style,
              const IRectangle& initial,
              unsigned long id );

IGraphicPushButton
 &setControlData( const IBitmapHandle& handle );

static Style
  currentDefaultStyle;

IIconControl*
  aIcon;
Boolean
  bSizeTo,
  returnBack;
GraphicType
  contains;
ISize
  border;

IGraphicPushButtonData
 *fGraphicPushButtonData;

};  // class IGraphicPushButton

INESTEDBITFLAGCLASSFUNCS(Style, IGraphicPushButton);

#pragma pack()

#endif  // _IGRAPHBT_
