#ifndef _IGRAPHIC_
#define _IGRAPHIC_
/*******************************************************************************
* FILE NAME: igraphic.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGraphic                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ivbase.hpp>
#include <irect.hpp>
#include <igbundle.hpp>
#include <itrnsfrm.hpp>


class IGraphicContext;

#pragma pack(4)

class IGraphic : public IVBase {
typedef IVBase
  Inherited;
protected:
/*------------------------------- Constructors -------------------------------*/
  IGraphic   ( );
  IGraphic   ( const IGraphicBundle& graphicBundle );
  IGraphic   ( const IGraphic&       graphic       );

IGraphic
  &operator= ( const IGraphic&       graphic       );

public:

virtual
  ~IGraphic  ( );

/*---------------------------------- Drawing ---------------------------------*/
virtual IGraphic
  &drawOn                ( IGraphicContext& graphicContext ) = 0;

/*----------------------------- Bounding Rectangle ---------------------------*/
virtual IRectangle
  boundingRect           ( IGraphicContext& graphicContext );

/*---------------------------- Graphic Bundles -------------------------------*/
virtual IGraphic
  &setGraphicBundle      ( const IGraphicBundle& graphicBundle );

virtual IGraphicBundle
  graphicBundle          ( ) const;

virtual IGraphic
  &removeGraphicBundle   ( );

virtual IBase::Boolean
  hasGraphicBundle       ( ) const;

/*------------------------ World Space Transformation ------------------------*/
enum TransformMethod {
  replace,
  rightMultiply,
  leftMultiply
  };

virtual IGraphic
  &rotateBy              ( double                  angle,
                           const IPoint&           point = IPoint(0,0)  ),
  &scaleBy               ( double                  xScale,
                           double                  yScale,
                           const IPoint&           point = IPoint(0,0)   ),
  &translateBy           ( const IPoint&           point                 ),
  &setTransformMatrix    ( const ITransformMatrix& transformMatrix       ),
  &setTransformMethod    ( TransformMethod         transformMethod = rightMultiply );

virtual IBase::Boolean
  hasTransformMatrix     ( ) const;

const ITransformMatrix
  transformMatrix        ( ) const;

IGraphic::TransformMethod
  transformMethod        ( ) const;

virtual IGraphic
  &resetTransformMatrix  ( );

/*--------------------------------- Hit Testing ------------------------------*/
virtual IBase::Boolean
  contains               ( IGraphicContext& graphicContext,
                           const IPoint&    point                );

virtual IGraphic
  &setHitSelected        ( IBase::Boolean   hitSelected = false  );

virtual IBase::Boolean
  isHitSelected          ( ) const;

virtual IGraphic
  &setHitSelectable      ( IBase::Boolean   hitSelectable = true );

virtual IBase::Boolean
  isHitSelectable        ( ) const;

/*------------------------------ Object Identifier ---------------------------*/
virtual IGraphic
  &setId                 ( unsigned long identifier );

virtual unsigned long
  id                     ( ) const;

protected:

/*------------------------------- Comparison ---------------------------------*/
IBase::Boolean
  operator == ( const IGraphic& graphic ) const,
  operator != ( const IGraphic& graphic ) const;

/*-------------------------------- Private -----------------------------------*/
private:
unsigned long
  fId;
TransformMethod
  fTm;
IGraphicBundle
 *fBundle;
ITransformMatrix
 *fTransMat;
IBase::Boolean
  fSelected,
  fSelectable,
  fIsList;
friend class IGList;
}; // IGraphic

#pragma pack()

#endif // _IGRAPHIC_
