#ifndef _IGRECT_
#define _IGRECT_
/*******************************************************************************
* FILE NAME: igrect.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGRectangle                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <igraphic.hpp>
#include <irect.hpp>


class IGraphicContext;

#pragma pack(4)

class IGRectangle : public IGraphic {
typedef IGraphic
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IGRectangle ( const IRectangle&  rectangle = IRectangle() );

  IGRectangle ( const IGRectangle& gRectangle );

IGRectangle&
  operator=   ( const IGRectangle& gRectangle );

virtual
  ~IGRectangle ();

/*-------------------------------- Drawing -----------------------------------*/
virtual IGRectangle
  &drawOn            ( IGraphicContext& graphicContext );

/*---------------------------- Corner Rounding -------------------------------*/
virtual IGRectangle
  &setRounding       ( const IPair& ellipseAxis = IPair(0,0) );

virtual IPair
  rounding           ( ) const;

/*-------------------------- Enclosing Rectangle -----------------------------*/
virtual IGRectangle
  &setEnclosingRect  ( const IRectangle& rectangle );

virtual IRectangle
  enclosingRect      ( ) const;

/*-------------------------------- Comparison --------------------------------*/
IBase::Boolean
  operator==       ( const IGRectangle& gRectangle ) const,
  operator!=       ( const IGRectangle& gRectangle ) const;

private:
/*------------------------------- Private ------------------------------------*/
IRectangle
  fRect;
IPair
  fRounding;
}; // IGRectangle

#pragma pack()

#endif // _IGRECT_
