#ifndef _IGREGION_
#define _IGREGION_
/*******************************************************************************
* FILE NAME: igregion.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGRegion                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <igraphic.hpp>
#include <ihandle.hpp>


class IGraphicContext;
class IGRectangle;
class IGPolygon;
class IGEllipse;
class IGPie;
class IGChord;

#pragma pack(4)

class IGRegion : public IGraphic {
typedef IGraphic
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGRegion   ( );

  IGRegion   ( const IRegionHandle&   regionHandle   );

  IGRegion   ( const IGRegion&        region         );

  IGRegion   ( const IGraphicContext& graphicContext,
               const IRectangle&      rectangle      );

  IGRegion   ( const IWindowHandle&   windowHandle   );

IGRegion
  &operator= ( const IGRegion&        region         );

virtual
  ~IGRegion  ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGRegion
  &drawOn      ( IGraphicContext& graphicContext );

/*----------------------------- Positioning ----------------------------------*/
virtual IGRegion
  &moveBy      ( const IPoint& point );

/*-------------------------- Modifying a Region ------------------------------*/
virtual IGRegion
  &clear       ( );

/*------------------------ Operators With Closed Shapes ----------------------*/
IGRegion
  &operator+= ( const IGRectangle& rect    ),
  &operator-= ( const IGRectangle& rect    ),
  &operator&= ( const IGRectangle& rect    ),
  &operator^= ( const IGRectangle& rect    ),
  &operator+= ( const IGPie&       pie     ),
  &operator-= ( const IGPie&       pie     ),
  &operator&= ( const IGPie&       pie     ),
  &operator^= ( const IGPie&       pie     ),
  &operator+= ( const IGChord&     chord   ),
  &operator-= ( const IGChord&     chord   ),
  &operator&= ( const IGChord&     chord   ),
  &operator^= ( const IGChord&     chord   ),
  &operator+= ( const IGPolygon&   polygon ),
  &operator-= ( const IGPolygon&   polygon ),
  &operator&= ( const IGPolygon&   polygon ),
  &operator^= ( const IGPolygon&   polygon ),
  &operator+= ( const IGEllipse&   ellipse ),
  &operator-= ( const IGEllipse&   ellipse ),
  &operator&= ( const IGEllipse&   ellipse ),
  &operator^= ( const IGEllipse&   ellipse );

/*----------------------- Operators With Other IGRegions ---------------------*/
IGRegion
  &operator+= ( const IGRegion& region ),
  &operator-= ( const IGRegion& region ),
  &operator&= ( const IGRegion& region ),
  &operator^= ( const IGRegion& region );

/*------------------------------- Conversion ---------------------------------*/
operator const IRegionHandle( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
IRegionHandle
  fRegion;
static IRegionHandle
  doRect    ( IGraphicContext& graphicContext, const IGRectangle& rect  ),
  doPie     ( IGraphicContext& graphicContext, const IGPie& pie         ),
  doChord   ( IGraphicContext& graphicContext, const IGChord& chord     ),
  doPolygon ( IGraphicContext& graphicContext, const IGPolygon& polygon ),
  doEllipse ( IGraphicContext& graphicContext, const IGEllipse& ellipse );
virtual IGRegion
  &rotateBy           ( double angle, const IPoint &pt ),
  &scaleBy            ( double xScale, double yScale, const IPoint& pt ),
  &translateBy        ( const IPoint& pt ),
  &setTransformMatrix ( const ITransformMatrix& transformMatrix );
}; // IGRegion

#pragma pack()

#endif // _IGREGION_
