#ifndef _IGROUPBX_
  #define _IGROUPBX_
/*******************************************************************************
* FILE NAME: igroupbx.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*    IGroupBox                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <itextctl.hpp>
#include <irect.hpp>

class ISize;
class IWindowHandle;
class IGroupBoxData;
class IResourceId;

#pragma pack(4)

class IGroupBox : public ITextControl  {
typedef ITextControl
  Inherited;
public:
class Style;
/*------------------------- Constructors -------------------------------------*/
  IGroupBox ( unsigned long        id,
              IWindow*             parent,
              IWindow*             owner,
              const IRectangle&    initial = IRectangle(),
              const Style&         style = defaultStyle() );

  IGroupBox ( unsigned long        id,
              IWindow*             parent );

  IGroupBox ( const IWindowHandle& handle );

virtual
 ~IGroupBox ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF1(Style, IGroupBox, IWindow);
                                  // style class definition
static const Style
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*---------------------------- Canvas Support --------------------------------*/
virtual IRectangle
  visibleRectangle   ( ) const;

#ifndef IC_WIN_FLAGNOP
/*----------------------------- Color Functions ------------------------------*/
virtual IColor
  foregroundColor () const;
#endif

/*-------------------------- Text Processing ---------------------------------*/
virtual IGroupBox
 &setText  ( const char*        text ),
 &setText  ( const IResourceId& text );


protected:
/*------------------------------- Layout -------------------------------------*/
virtual ISize
  calcMinimumSize() const;

private:
/*--------------------------------- Private ----------------------------------*/
friend class IGroupHandler;

static Style
  currentDefaultStyle;

IGroupBoxData
 *fGroupBoxData;

/*---------------------------- Hidden Functions ------------------------------*/
  IGroupBox ( const IGroupBox& groupBox );
IGroupBox
 &operator= ( const IGroupBox& groupBox );

}; // class IGroupBox

INESTEDBITFLAGCLASSFUNCS(Style, IGroupBox);

#pragma pack()

#endif  /* _IGROUPBX_ */
