/*******************************************************************************
* FILE NAME: iguibndl.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGUIBundle                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   Portions or this component are based on work originating from Taligent.    *
*   (C) Copyright Taligent, Inc. 1996 - All rights reserved.                   *
*                                                                              *
*******************************************************************************/
#ifndef _IGUIBNDL_
#define _IGUIBNDL_

// forward references
class IComponentFrameWindow;
class IComponent;
class IView;
class IMainMenuHandler;
class IWindow;
class IMenuBar;
class IToolBar;
class IFrameWindow;

#include <icmdhdr.hpp>
#include <icconst.h>


// classes defined in this module
class IGUIBundle;


#pragma pack(4)


/*------------------------ Resource Constants --------------------------------*/

enum EMenuBar {
    kFileMenu =         IC_ID_FILE,
    kEditMenu =         IC_ID_EDIT,
    kViewMenu =         IC_ID_VIEW,
    kHelpMenu =         IC_ID_HELP
};

enum EMenus {
    kFileNew =          IC_ID_NEW,
    kFileOpen =         IC_ID_OPEN,
    kFileSave =         IC_ID_SAVE,
    kFileSaveAs =       IC_ID_SAVE_AS,
    kFileExit =         IC_ID_EXIT,
    kFileUpdate =       IC_ID_UPDATE,
    kFileSaveCopyAs =   IC_ID_SAVE_COPY_AS,

    kEditUndo =         IC_ID_UNDO,
    kEditCut =          IC_ID_CUT,
    kEditCopy =         IC_ID_COPY,
    kEditPaste =        IC_ID_PASTE,
    kEditPasteSpecial = IC_ID_PASTESPECIAL,
    kEditPasteLink =    IC_ID_PASTELINK,
    kEditDelete =       IC_ID_DELETE,
    kEditSelectAll =    IC_ID_SELECTALL,
    kEditInsertObject = IC_ID_INSERT,
    kEditLinks =        IC_ID_EDITLINKS,

    kVerb0 =            IC_ID_VERB0,
    kVerbMin =          kVerb0,
    kVerb1 =            IC_ID_VERB1,
    kVerb2 =            IC_ID_VERB2,
    kVerb3 =            IC_ID_VERB3,
    kVerb4 =            IC_ID_VERB4,
    kVerb5 =            IC_ID_VERB5,
    kVerb6 =            IC_ID_VERB6,
    kVerb7 =            IC_ID_VERB7,
    kVerb8 =            IC_ID_VERB8,
    kVerb9 =            IC_ID_VERB9,
    kVerb10 =           IC_ID_VERB10,
    kVerb11 =           IC_ID_VERB11,
    kVerb12 =           IC_ID_VERB12,
    kVerb13 =           IC_ID_VERB13,
    kVerb14 =           IC_ID_VERB14,
    kVerb15 =           IC_ID_VERB15,
    kVerb16 =           IC_ID_VERB16,
    kVerb17 =           IC_ID_VERB17,
    kVerb18 =           IC_ID_VERB18,
    kVerb19 =           IC_ID_VERB19,
    kVerbMax =          kVerb19,

    kConvert =          IC_ID_CONVERT,

    kViewToolbar =      IC_ID_TOOLBAR,

    kHelpAbout =        IC_ID_ABOUT
};

enum EWindowID {
    kDefaultView =      IC_CDF_DEFAULT_VIEW_ID,
    kStandaloneMenu =   IC_CDF_STANDALONE_MENU_ID,
    kEmbeddedMenu =     IC_CDF_EMBEDDED_MENU_ID,
    kInplaceMenu =      IC_CDF_INPLACE_MENU_ID,
    kToolBar =          IC_CDF_TOOLBAR_ID,
    kPopupMenu =        IC_CDF_POPUP_MENU_ID
};


/*******************************************************************************
*                                                                              *
*   Class IGUIBundle                                                           *
*                                                                              *
*   Object that controls Models, Views and windows                             *
*                                                                              *
*******************************************************************************/

class IGUIBundle
{
public:

/*----------------------- Construction/Destruction ---------------------------*/

                                IGUIBundle();
                                ~IGUIBundle();


/*---------------------------- Informational ---------------------------------*/

    IComponent&                 component() const;
    IFrameWindow&               frameWindow() const;
    IView&                      view() const;
#ifdef IC_LIBRARYUSEONLY    
    IFrameWindow&               inPlaceFrame() const;
    IView&                      inPlaceView() const;
    IFrameWindow&               objectFrame() const;
#endif    
    IView&                      objectView() const;
    IMenuBar&                   objectMenuBar();
    IToolBar&                   objectToolBar();


/*----------------------------- Adopt/orphan ---------------------------------*/

    virtual Boolean             adoptComponent( IComponent* );
    virtual Boolean             adoptFrameWindow( IComponentFrameWindow* );
    virtual Boolean             adoptView( IView* );


/*--------------------------- Command Handlers -------------------------------*/

    virtual Boolean             handleDefaultMenuCommands( ICommandEvent& );
    virtual void                handleFileNew();
    virtual void                handleFileOpen();
    virtual void                handleFileSave();
    virtual void                handleFileSaveAs( Boolean copy = false );
    virtual void                handleCut();
    virtual void                handleCopy();
    virtual void                handlePaste();
    virtual void                handlePasteSpecial();
    virtual void                handlePasteLink();
    virtual void                handleExit( Boolean close = false );
    virtual void                handleInsertObject();
    virtual void                handleEditLinks();
    virtual void                handleDoVerb( unsigned iVerb );
    virtual void                handleConvert();
    virtual void                handleDelete();
    virtual void                handleSelectAll( Boolean );


/*------------------------------ Helper Methods ------------------------------*/

#ifdef IC_LIBRARYUSEONLY    
    virtual void                createInPlaceWindows();
    virtual Boolean             destroyInPlaceWindows();
#endif    

protected:
    virtual Boolean             okToDiscardFile();
#ifdef IC_LIBRARYUSEONLY    
    void                        useInPlaceWindows( Boolean use = true );
#endif    

private:
// Private members
    IComponent*                 fpComponent;
    IComponentFrameWindow*      fpFrameWindow;
    IView*                      fpView;

    IView*                      fpInPlaceView;
    IFrameWindow*               fpInPlaceFrame;

    // for menus and tools
    IMenuBar*                   fpInPlaceBar;
    IToolBar*                   fpInPlaceTools;

    ICommandConnectionTo<IGUIBundle>* fpMenuHandler;
    IMainMenuHandler*           fpMainMenuHandler;

    Boolean                     fbSelectAll;
    Boolean                     fbUsingInPlace;

friend class IComponentImp;
friend class IMainMenuHandler;
}; // class IGUIBundle

  #include <iguibndl.inl>


#pragma pack()


#endif // _IGUIBNDL_

