#ifndef _IHELP_
#define _IHELP_
/*******************************************************************************
* FILE NAME: ihelp.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IHelpWindow                                                              *
*     IHelpWindow::Settings                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <iwindow.hpp>
#include <ibitflag.hpp>
#include <istring.hpp>

class IEvent;
class IFrameWindow;
class IHelpSettingsData;
class IHelpWindowData;
class IPoint;
class IRectangle;
class IResourceId;
class ISize;
class IWindowHandle;

#pragma pack(4)

class IHelpWindow : public IWindow {
typedef IWindow
  Inherited;
public:
class Settings;
class Style;
/*------------------------------- Constructors -------------------------------*/
  IHelpWindow ( IFrameWindow*             associatedWindow = 0,
                const IHelpWindow::Style& style = defaultStyle() );

  IHelpWindow ( const IResourceId&        helpTable,
                IFrameWindow*             associatedWindow,
                const IHelpWindow::Style& style = defaultStyle() );

  IHelpWindow ( const Settings&           settings,
                IFrameWindow*             associatedWindow = 0,
                const IHelpWindow::Style& style = defaultStyle() );

  IHelpWindow ( const IWindowHandle& helpWindowHandle );

virtual
 ~IHelpWindow ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF0(Style, IHelpWindow);
static const Style
  IC_IMPORTU noStyle,
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU ipfCompatible;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

/*-------------------------------- Attributes --------------------------------*/
Boolean
  isIPFCompatible   ( ) const;

/*------------------------------ Settings -------------------------------*/
class Settings : public IBase {
typedef IBase
  Inherited;
public:
/*---------------------------- Constructors -----------------------------*/
  Settings ( );

/*-------------------------- Help Information ---------------------------*/
Settings
 &setHelpResLibrary ( const char*   helpTableResLibrary ),
 &setHelpTable      ( unsigned long helpTable ),
 &setLibraries      ( const char*   helpLibraryNames ),
#ifndef IC_WIN_FLAGNOP
 &setTutorial       ( const char*   tutorial ),
#endif
 &setUsingHelp      ( unsigned long panelId );

/*---------------------- Help Window Customization ----------------------*/
Settings
 &setAccelerator     ( unsigned long      acceleratorId ),
 &setAccelResLibrary ( const char*        menuAccelResLibrary ),
 &setMenuBar         ( unsigned long      menuBarId ),
 &setTitle           ( const char*        titleText ),
 &setTitle           ( const IResourceId& titleId );

private:
/*------------------------------- Private -------------------------------*/
friend class IHelpWindow;

IString
  title,
  tutorial,
  helpLibraries,
  HTResLib,
  MAResLib;

unsigned long
  usingHelpId,
  helpTableId,
  menuBarId,
  acceleratorId;

IHelpSettingsData
 *pHelpSettings;
};  // IHelpWindow::Settings

/*--------------------------- Application Windows ----------------------------*/
virtual IHelpWindow
 &setActiveWindow     ( IFrameWindow* activeWindow,
                        IFrameWindow* relativeWindow = 0 ),
 &setAssociatedWindow ( IFrameWindow* associatedWindow );

/*------------------------------- Enumerations -------------------------------*/
enum HelpType {
  index,
  general,
  contents,
  keys,
  usingHelp
#if (IC_OBSOLETE <= IC_OBSOLETE_2)
 ,using=usingHelp
#endif
}; // HelpType

/*------------------------------- Help Panels --------------------------------*/
virtual IHelpWindow
 &addLibraries ( const char*        helpLibraryNames ),
 &hide         ( ),
 &setHelpTable ( const IResourceId& helpTable ),
 &setUsingHelp ( unsigned long      panelId ),
 &show         ( HelpType           helpType ),
 &show         ( const IResourceId& panelId ),
 &show         ( const char*        panelName );

/*-------------------------------- Title Text --------------------------------*/
virtual IHelpWindow
 &setTitle ( const char*        titleText ),
 &setTitle ( const IResourceId& titleId );

/*----------------------------- Window Accessing -----------------------------*/
IWindowHandle
  communicationWindow ( ) const,
  contentsWindow      ( ) const,
  coverPageWindow     ( ) const,
  indexWindow         ( ) const,
  searchListWindow    ( ) const,
  viewedPagesWindow   ( ) const;
virtual IWindowHandle
  handle              ( ) const;
static IHelpWindow
 *helpWindow          ( const IWindow* window );

/*---------------------------- Panel Identifiers -----------------------------*/
virtual IHelpWindow
 &hidePanelIds ( ),
 &showPanelIds ( Boolean visibleId = true );

/*---------------------------- Window Positioning ----------------------------*/
virtual IHelpWindow
 &sizeTo     ( const ISize&      size ),
 &moveTo     ( const IPoint&     point ),
 &moveSizeTo ( const IRectangle& rectangle );

/*------------------------ Sending and Posting Events ------------------------*/
virtual IEventResult
  sendEvent ( EventType               eventType,
              const IEventParameter1& parm1 = 0,
              const IEventParameter2& parm2 = 0 ) const,
  sendEvent ( unsigned long           eventId,
              const IEventParameter1& parm1 = 0,
              const IEventParameter2& parm2 = 0 ) const,
  sendEvent ( const IEvent&           event ) const;

private:
/*------------------------------ Hidden Members ------------------------------*/
  IHelpWindow ( const IHelpWindow& helpWindow );
IHelpWindow
 &operator=   ( const IHelpWindow& helpWindow );
IHelpWindow
 &show        ( Boolean            show = true );

/*--------------------------------- Private ----------------------------------*/
IHelpWindowData
 *fHelpWindowData;
static Style
  currentDefaultStyle;

}; // IHelpWindow

#pragma pack()

  #include <ihelp.inl>

#endif /* _IHELP_ */
