/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGHeapAsDilTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGHeapAsDilTableCursor <Element, ElementOps>::
IGHeapAsDilTableCursor
  (IGHeapAsDilTable
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGHeapAsDilTableCursor <Element, ElementOps>&
IGHeapAsDilTableCursor <Element, ElementOps>::
operator=
  (IGHeapAsDilTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGHeapAsDilTableCursor <Element, ElementOps>::
IGHeapAsDilTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGHeapAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGHeapAsDilTable <Element, ElementOps>::
IGHeapAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGHeapAsDilTable <Element, ElementOps>::
IGHeapAsDilTable
  (IGHeapAsDilTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGHeapAsDilTable <Element, ElementOps>&
IGHeapAsDilTable <Element, ElementOps>::
operator= (IGHeapAsDilTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGHeapAsDilTable <Element, ElementOps>::
IGHeapAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGHeapAsDilTable
 <Element, ElementOps>::Implementation&
IGHeapAsDilTable <Element, ElementOps>::
ImplOf (IGHeapAsDilTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IHeapAsDilTable
// ---

// public members

template <class Element>
inline
IHeapAsDilTable <Element>::
IHeapAsDilTable (INumber numberOfElements)
: IGHeapAsDilTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IHeapAsDilTable <Element>::
IHeapAsDilTable (PureImplementation& impl)
: IGHeapAsDilTable
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGHeapAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGHeapAsDilTable <Element, ElementOps>::
IVGHeapAsDilTable (INumber numberOfElements)
: IGHeapAsDilTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGHeapAsDilTable <Element, ElementOps>::
IVGHeapAsDilTable (PureImplementation& impl)
: IGHeapAsDilTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVHeapAsDilTable
// ---

// public members

template <class Element>
inline
IVHeapAsDilTable <Element>::
IVHeapAsDilTable (INumber numberOfElements)
: IVGHeapAsDilTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVHeapAsDilTable <Element>::
IVHeapAsDilTable (PureImplementation& impl)
: IVGHeapAsDilTable
   <Element, IStdOps <Element> > (impl)
{
}
