/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IHPLST_H
#define _IHPLST_H

#include <iahp.h>
#include <iichp.h>
#include <iivhp.h>
#include <iihplst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGHeapAsList;

template <class Element, class ElementOps>
class IGHeapAsListCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGHeapAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGHeapAsListCursor
                            (IGHeapAsList
                              <
                               Element, ElementOps> const&);

  IGHeapAsListCursor <Element, ElementOps>&
           operator=        (IGHeapAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGHeapAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGHeapAsList :
  public IAHeap <Element> {
protected:

  typedef  IGHeapAsList <Element, ElementOps> Self;

  typedef  IHeapAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICHeapImpl
            <PureImplementation> Implementation;
#endif

#define IGHeapAsListTypedef(Element, ElementOps)\
  typedef  IHeapAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGHeapAsListTypedef (Element, ElementOps);

public:

  typedef  IGHeapAsListCursor
            <Element, ElementOps> Cursor;


           IGHeapAsList
                            (INumber = 100);

           IGHeapAsList
                            (IGHeapAsList
                              <
                               Element, ElementOps> const&);

  IGHeapAsList <Element, ElementOps>&
           operator=        (IGHeapAsList
                              <
                               Element, ElementOps> const&);


protected:

           IGHeapAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGHeapAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGHeapAsListCursor
            <Element, ElementOps>;



};

template <class Element>
class IHeapAsList :
  public IGHeapAsList
          <Element, IStdOps <Element> > {

  typedef  IGHeapAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IHeapAsList <Element> Self;

#define IHeapAsListTypedef(Element)\
  typedef  IHeapAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IHeapAsList
                            (INumber = 100);


protected:

           IHeapAsList
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGHeapAsList :
  public IGHeapAsList
          <Element, ElementOps > {

  typedef  IVGHeapAsList
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVHeapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICHeapImpl
            <IVHeapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGHeapAsListTypedef(Element, ElementOps)\
  typedef  IHeapAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGHeapAsListTypedef (Element, ElementOps);

public:

           IVGHeapAsList
                            (INumber = 100);


protected:

           IVGHeapAsList
                              (PureImplementation&);

private:


};

template <class Element>
class IVHeapAsList :
  public IVGHeapAsList
          <Element, IStdOps <Element> > {

  typedef  IVGHeapAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVHeapAsList <Element> Self;

#define IVHeapAsListTypedef(Element)\
  typedef  IVHeapAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVHeapAsList
                            (INumber = 100);


protected:

           IVHeapAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ihplst.inl>

#pragma info (restore)
#pragma pack ()

#endif
