/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IHPTAB_H
#define _IHPTAB_H

#include <iahp.h>
#include <iichp.h>
#include <iivhp.h>
#include <iihptab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGHeapAsTable;

template <class Element, class ElementOps>
class IGHeapAsTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGHeapAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGHeapAsTableCursor
                            (IGHeapAsTable
                              <
                               Element, ElementOps> const&);

  IGHeapAsTableCursor <Element, ElementOps>&
           operator=        (IGHeapAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGHeapAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGHeapAsTable :
  public IAHeap <Element> {
protected:

  typedef  IGHeapAsTable <Element, ElementOps> Self;

  typedef  IHeapAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICHeapImpl
            <PureImplementation> Implementation;
#endif

#define IGHeapAsTableTypedef(Element, ElementOps)\
  typedef  IHeapAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGHeapAsTableTypedef (Element, ElementOps);

public:

  typedef  IGHeapAsTableCursor
            <Element, ElementOps> Cursor;


           IGHeapAsTable
                            (INumber = 100);

           IGHeapAsTable
                            (IGHeapAsTable
                              <
                               Element, ElementOps> const&);

  IGHeapAsTable <Element, ElementOps>&
           operator=        (IGHeapAsTable
                              <
                               Element, ElementOps> const&);


protected:

           IGHeapAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGHeapAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGHeapAsTableCursor
            <Element, ElementOps>;



};

template <class Element>
class IHeapAsTable :
  public IGHeapAsTable
          <Element, IStdOps <Element> > {

  typedef  IGHeapAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IHeapAsTable <Element> Self;

#define IHeapAsTableTypedef(Element)\
  typedef  IHeapAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IHeapAsTable
                            (INumber = 100);


protected:

           IHeapAsTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGHeapAsTable :
  public IGHeapAsTable
          <Element, ElementOps > {

  typedef  IVGHeapAsTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVHeapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICHeapImpl
            <IVHeapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGHeapAsTableTypedef(Element, ElementOps)\
  typedef  IHeapAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGHeapAsTableTypedef (Element, ElementOps);

public:

           IVGHeapAsTable
                            (INumber = 100);


protected:

           IVGHeapAsTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVHeapAsTable :
  public IVGHeapAsTable
          <Element, IStdOps <Element> > {

  typedef  IVGHeapAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVHeapAsTable <Element> Self;

#define IVHeapAsTableTypedef(Element)\
  typedef  IVHeapAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVHeapAsTable
                            (INumber = 100);


protected:

           IVHeapAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ihptab.inl>

#pragma info (restore)
#pragma pack ()

#endif
