/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGHeapAsTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGHeapAsTableCursor <Element, ElementOps>::
IGHeapAsTableCursor
  (IGHeapAsTable
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGHeapAsTableCursor <Element, ElementOps>&
IGHeapAsTableCursor <Element, ElementOps>::
operator=
  (IGHeapAsTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGHeapAsTableCursor <Element, ElementOps>::
IGHeapAsTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGHeapAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGHeapAsTable <Element, ElementOps>::
IGHeapAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGHeapAsTable <Element, ElementOps>::
IGHeapAsTable
  (IGHeapAsTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGHeapAsTable <Element, ElementOps>&
IGHeapAsTable <Element, ElementOps>::
operator= (IGHeapAsTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGHeapAsTable <Element, ElementOps>::
IGHeapAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGHeapAsTable
 <Element, ElementOps>::Implementation&
IGHeapAsTable <Element, ElementOps>::
ImplOf (IGHeapAsTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IHeapAsTable
// ---

// public members

template <class Element>
inline
IHeapAsTable <Element>::
IHeapAsTable (INumber numberOfElements)
: IGHeapAsTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IHeapAsTable <Element>::
IHeapAsTable (PureImplementation& impl)
: IGHeapAsTable
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGHeapAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGHeapAsTable <Element, ElementOps>::
IVGHeapAsTable (INumber numberOfElements)
: IGHeapAsTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGHeapAsTable <Element, ElementOps>::
IVGHeapAsTable (PureImplementation& impl)
: IGHeapAsTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVHeapAsTable
// ---

// public members

template <class Element>
inline
IVHeapAsTable <Element>::
IVHeapAsTable (INumber numberOfElements)
: IVGHeapAsTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVHeapAsTable <Element>::
IVHeapAsTable (PureImplementation& impl)
: IVGHeapAsTable
   <Element, IStdOps <Element> > (impl)
{
}
