/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIABAG_H
#define _IIABAG_H

#include <iiacllct.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

class IABagImpl : public IACollectionImpl {
public:

          ~IABagImpl
                            ();

  virtual
  void     Antivalence      (IABagImpl const&);

  virtual
  void     AddAntivalence   (IABagImpl const&,
                             IABagImpl const&); 

  virtual
  void     AddDifference    (IABagImpl const&,
                             IABagImpl const&); 

  virtual
  void     AddIntersection  (IABagImpl const&,
                             IABagImpl const&);

  virtual
  void     AddUnion         (IABagImpl const&,
                             IABagImpl const&);

  virtual
  void     Difference       (IABagImpl const&);

  virtual
  void     Intersection     (IABagImpl const&);

  virtual
  INumber  NumberOfDifferentElements
                            () const = 0;

  virtual
  IBoolean SetToNextDifferentElement
                            (ICursorImpl&) const = 0;

  virtual
  void     Union            (IABagImpl const&);

  virtual
  IBoolean operator==       (IABagImpl const&) const = 0;

  IBoolean operator!=       (IABagImpl const&) const;

protected:

           IABagImpl
                            (Ops&);

private:


};

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
