/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIACLLCT_H
#define _IIACLLCT_H

#include <iiglobal.h>
#include <iexctxt.h>

#include <iivcllct.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

class IACollectionImpl;

class ICursorImpl {
public:

           ICursorImpl      (IACollectionImpl const&);

  virtual ~ICursorImpl      ();

  virtual
  ICursorImpl*
           Clone            () const = 0;

  virtual
  void     Copy             (ICursorImpl const&) = 0;

  void const*
           Element          () const;

  virtual
  void     Invalidate       () = 0;

  IBoolean IsFor            (IACollectionImpl const&) const;

  virtual
  IBoolean IsInBetween      () const = 0;

  virtual
  IBoolean IsMngCursor      () const;

  virtual
  IBoolean IsValid          () const = 0;

  IPosition
           Position         () const;

  IBoolean SetToFirst       ();

  IBoolean SetToLast        ();

  IBoolean SetToNext        ();

  void     SetToPosition    (IPosition);

  IBoolean SetToPrevious    ();

  virtual
  IBoolean operator==       (ICursorImpl const&) const;

  IBoolean operator!=       (ICursorImpl const&) const;

protected:

  IACollectionImpl const*
           ivCollection;

  static
  void*    CheckPointer     (void*);

private:


};


class IACollectionOps;

class IACollectionImpl : public IVCollectionImpl {
public:

  typedef  IACollectionOps Ops;

          ~IACollectionImpl ();

  IBoolean Add              (void const*);

  virtual
  IBoolean Add              (void const*, ICursorImpl&) = 0;

  void     AddAsFirst       (void const*);

  virtual
  void     AddAsFirst       (void const*, ICursorImpl&); // = 0

  void     AddAsLast        (void const*);

  virtual
  void     AddAsLast        (void const*, ICursorImpl&); // = 0

  virtual
  void     AddAsNext        (void const*, ICursorImpl&); // = 0

  virtual
  void     AddAsPrevious    (void const*, ICursorImpl&); // = 0

  void     AddAtPosition    (IPosition, void const*);

  virtual
  void     AddAtPosition    (IPosition,
                             void const*, ICursorImpl&); // = 0

  IBoolean AddOrReplaceElementWithKey
                            (void const*);

  virtual
  IBoolean AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&); // = 0

  virtual
  void     AddAllFrom       (IACollectionImpl const&);

  virtual
  IBoolean AllElementsDo    (IApplFunc, void*);

  virtual
  void*    Any              () const = 0;

  static
  void*    CheckPointer     (void*);

  virtual
  char const*
           ClassName        () const = 0;

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  IBoolean Contains         (void const*) const; // = 0

  virtual
  IBoolean ContainsAllFrom  (IACollectionImpl const&) const; // = 0

  virtual
  IBoolean ContainsAllKeysFrom
                            (IACollectionImpl const&) const; // = 0

  virtual
  IBoolean ContainsElementWithKey
                            (void const*) const; // = 0

  virtual
  void     Copy             (IACollectionImpl const&);

  virtual
  ICursorImpl*
           CreateCursor     () const = 0;

  virtual
  ICursorImpl*
           CreateMngCursor  () const = 0;

  void     Delete           ();

  virtual
  void*    ElementAt        (ICursorImpl const&) const = 0;

  virtual
  void*    ElementAtPosition
                            (IPosition) const; // = 0

  virtual
  void*    ElementWithKey   (void const*) const; // = 0

  virtual
  void*    First            () const;

  void     Initialize       ();

  virtual
  IBoolean IsBounded        () const = 0;

  virtual
  IBoolean IsConsistent     () const = 0;

  virtual
  IBoolean IsEmpty          () const;

  virtual
  IBoolean IsFirstAt        (ICursorImpl const&) const;

  virtual
  IBoolean IsFull           () const = 0;

  virtual
  IBoolean IsLastAt         (ICursorImpl const&) const;

  virtual
  void*    Key              (void const*) const; // = 0

  virtual
  void*    Last             () const;

  virtual
  IBoolean Locate           (void const*, ICursorImpl&) const; // = 0

  virtual
  IBoolean LocateElementWithKey
                            (void const*, ICursorImpl&) const; // = 0

  virtual
  IBoolean LocateNext       (void const*, ICursorImpl&) const; // = 0

  virtual
  IBoolean LocateNextElementWithKey
                            (void const*, ICursorImpl&) const; // = 0

  IBoolean LocateOrAdd      (void const*);

  virtual
  IBoolean LocateOrAdd      (void const*, ICursorImpl&); // = 0
  
  IBoolean LocateOrAddElementWithKey
                            (void const*);

  virtual
  IBoolean LocateOrAddElementWithKey
                            (void const*, ICursorImpl&); // = 0

  virtual
  void     LockBeforeReading
                            (long = -1);

  virtual
  void     LockBeforeWriting
                            (long = -1);

  virtual
  INumber  MaxNumberOfElements
                            () const;

  virtual
  INumber  NumberOfDifferentKeys
                            () const; // = 0

  virtual	
  INumber  NumberOfElements () const = 0;

  virtual
  INumber  NumberOfElementsWithKey
                            (void const*) const; // = 0

  virtual
  INumber  NumberOfOccurrences
                            (void const*) const; // = 0

  virtual
  IPosition
           PositionAt       (ICursorImpl const&) const; // = 0

  virtual
  IBoolean Remove           (void const*); // = 0

  virtual
  INumber  RemoveAll        () = 0;

  virtual
  INumber  RemoveAll        (IPredFunc, void*) = 0;

  virtual
  INumber  RemoveAllElementsWithKey
                            (void const*); // = 0

  virtual
  INumber  RemoveAllOccurrences
                            (void const*); // = 0

  virtual
  void     RemoveAt         (ICursorImpl&) = 0;


  virtual
  void     RemoveAtPosition (IPosition); // = 0

  virtual
  IBoolean RemoveElementWithKey
                            (void const*); // = 0

  virtual
  void     RemoveFirst      ();

  virtual
  void     RemoveLast       ();

  virtual
  void     ReplaceAt        (ICursorImpl const&, void const*) = 0;

  virtual
  void     ReplaceAtPosition
                            (IPosition, void const*);

  IBoolean ReplaceElementWithKey
                            (void const*);

  virtual
  IBoolean ReplaceElementWithKey
                            (void const*, ICursorImpl&); // = 0

  virtual
  void     Reverse          (); // = 0

  virtual
  IBoolean SetToFirst       (ICursorImpl&) const = 0;

  virtual
  IBoolean SetToLast        (ICursorImpl&) const; // = 0

  virtual
  IBoolean SetToNext        (ICursorImpl&) const = 0;

  virtual
  IBoolean SetToNextWithDifferentKey
                            (ICursorImpl&) const; // = 0

  virtual
  void     SetToPosition    (IPosition, ICursorImpl&) const; // = 0

  virtual
  IBoolean SetToPrevious    (ICursorImpl&) const; // = 0

  virtual
  void     Sort             (ICompFunc, void*); // = 0

  virtual
  void     UnlockAfterReading
                            ();

  virtual
  void     UnlockAfterWriting
                            ();

  virtual
  TStream& operator<<=      (TStream&) = 0;

  virtual
  TStream& operator>>=      (TStream&) const = 0;

protected:

#pragma SOMAsDefault (off)

  struct Predicate {

    static
    IBoolean IsContained      (void const*, void*);

    static
    IBoolean IsNotContained   (void const*, void*);

  };

#pragma SOMAsDefault (pop)

           IACollectionImpl (Ops&);

           IACollectionImpl (IACollectionImpl const&);

  static
  inline
  ICursorImpl&
           CursorOf         (IACollectionImpl const&);

  static
  Ops&     OpsOf            (IACollectionImpl const&);

private:

  static
  ICollectionExceptionText
           cvExceptionText;

  Ops*     ivOps;

  INumber  ivReferenceCount;

  ICursorImpl*
           ivDummyCursor;


};

class IACollectionOps {
public:

  virtual ~IACollectionOps  ();

protected:

private:


};

#pragma SOMAsDefault (pop)

#include <iiacllct.inl>

#pragma info (restore)
#pragma pack ()

#endif
