/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIASB_H
#define _IIASB_H

#include <iiacllct.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

class IASortedBagImpl : public IACollectionImpl {
public:

          ~IASortedBagImpl
                            ();

  virtual
  void     Antivalence      (IASortedBagImpl const&);

  virtual
  void     AddAntivalence   (IASortedBagImpl const&,
                             IASortedBagImpl const&); 

  virtual
  void     AddDifference    (IASortedBagImpl const&,
                             IASortedBagImpl const&); 

  virtual
  void     AddIntersection  (IASortedBagImpl const&,
                             IASortedBagImpl const&);

  virtual
  void     AddUnion         (IASortedBagImpl const&,
                             IASortedBagImpl const&);

  virtual
  long     Compare          (IASortedBagImpl const&,
                             ICompFunc, void*) const;

  virtual
  void     Difference       (IASortedBagImpl const&);

  virtual
  void     Intersection     (IASortedBagImpl const&);

  virtual
  INumber  NumberOfDifferentElements
                            () const = 0;

  virtual
  IBoolean SetToNextDifferentElement
                            (ICursorImpl&) const = 0;

  virtual
  void     Union            (IASortedBagImpl const&);

  virtual
  IBoolean operator==       (IASortedBagImpl const&) const = 0;

  IBoolean operator!=       (IASortedBagImpl const&) const;

protected:

           IASortedBagImpl
                            (Ops&);

private:


};

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
